@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{asset('public/modules/supportticket/css/style.css')}}"/>
    <style>
        .subject_link {
            color: #7C32FF !important;
            font-weight: 300 !important;
        }

        .limit_text {
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;

        }

        .no_reply_ticket {
            font-weight: 600 !important;
        }

        .color_inherit {
            color: #828bb2 !important;
        }

    </style>

@endpush
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area">
        <div class="container-fluid p-0">
            <form action="#">
                <div class="white-box">
                    <div class="d-flex justify-content-between">
                        <div class="bc-pages">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px d-none"
                                id="">{{__('ticket.course_ticket')}}</h3>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-lg-4">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label"
                                       for="f_priority_id">{{ __('ticket.priority') }}</label>
                                <select name="f_priority_id" id="f_priority_id" class="primary_select mb-15">
                                    <option value="" selected>{{__('common.Select')}}</option>
                                    @foreach ($PriorityList as $key => $item)
                                        <option value="{{ $item->id }}">{{ $item->name }} </option>
                                    @endforeach

                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="primary_input mb-25">
                                <label class="primary_input_label" for="f_status_id">{{ __('common.Status') }}</label>
                                <select name="f_status_id" id="f_status_id" class="primary_select mb-15">
                                    <option value="" selected>{{__('common.Select')}}</option>
                                    @foreach ($StatusList as $key => $status)
                                        <option {{isset($status_id)?$status_id == $status->id?'selected':'':''}}
                                                value="{{ $status->id }}">{{ $status->name }} </option>
                                    @endforeach

                                </select>
                            </div>
                        </div>

                        <div class="col-lg-12  text-end">
                            <a href="{{route('ticket.course_tickets.index')}}"
                               class="primary-btn      fix-gr-bg reset_btn w-fit">
                                <i class="ti-search"></i>
                                {{__('common.Reset')}} </a>
                        </div>
                    </div>
                </div>
            </form>

            <div class="white-box mt-4">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="d-flex justify-content-between">
                            <h3 class="mb-20" id="page_title">{{__('ticket.course_ticket_list')}}</h3>
                            @if(permissionCheck('ticket.tickets.create'))
                                <div class="bc-pages">
                                    <a href="{{ route('ticket.tickets.create') }}" id="add_new"
                                       class="primary-btn small fix-gr-bg mb-2">
                                        <span class="ti-plus pe-2"></span>
                                        {{__('common.Add New')}}
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                    <div class="col-lg-12">

                        <div class="row">
                            <div class="col-lg-12">

                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">

                                        <div class="">
                                            <div id="model_list">
                                                <table id="dataListTable" class="table">
                                                    <thead>
                                                    <tr>

                                                        <th scope="col" width="5%">{{__('common.SL')}}</th>
                                                        <th scope="col" width="15%">{{__('common.User')}}</th>
                                                        <th scope="col" width="55%">{{__('ticket.ticket')}}</th>
                                                        <th scope="col" width="15%">{{__('ticket.agent_assign')}}</th>
                                                        <th class="nowrap" scope="col"
                                                            width="10%">{{__('common.Action')}}</th>
                                                    </tr>
                                                    </thead>


                                                </table>
                                                <div class="modal fade admin-query" id="deleteItem">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title">{{__('common.delete')}}
                                                                    {{__('ticket.ticket')}}</h4>
                                                                <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"><i
                                                                        class="ti-close "></i></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="text-center">
                                                                    <h4>{{__('common.Are you sure to delete ?')}}</h4>
                                                                </div>
                                                                <div class="mt-40 d-flex justify-content-between">
                                                                    <button type="button" class="primary-btn tr-bg"
                                                                            data-bs-dismiss="modal">{{__('common.Cancel')}}</button>
                                                                    <form id="deleteForm"
                                                                          action="{{route('ticket.tickets.destroy')}}"
                                                                          method="POST">
                                                                        @csrf
                                                                        <input type="hidden" id="dataId" name="id">
                                                                        <input type="submit"
                                                                               class="primary-btn fix-gr-bg"
                                                                               value="Delete"/>
                                                                    </form>
                                                                </div>
                                                            </div>

                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <input type="hidden" value="{{route('ticket.course_tickets.datatable')}}" id="course_support_ticket_url">
    </section>

@endsection

@push('scripts')
    <script type="text/javascript">
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true

            dataTableOptions.ajax = {
                url: $("#course_support_ticket_url").val(),
                data: function (d) {
                    d.f_priority_id = $("#f_priority_id").val();
                    d.f_status_id = $("#f_status_id").val();

                }
            };
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id'},
                {data: 'username', name: 'user.email'},
                {data: 'ticket', name: 'support_tickets.subject'},
                {data: 'assign_aggent', name: 'assign_aggent'},
                {data: 'action', name: 'action'}
            ]

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2,]);

            let table = $('#dataListTable').DataTable(dataTableOptions);


            $(document).on('change', '#f_priority_id, #f_status_id', function (event) {
                event.preventDefault();
                resetAfterChange();
                $('.niceSelect').niceSelect('update');
            });


            function resetAfterChange() {
                table.ajax.reload();
            }

            $(document).on('click', '.delete_ticket', function (event) {
                event.preventDefault();
                let id = $(this).data('id');
                $('#deleteItem').modal('show');
                $('#dataId').val(id);
            });

            $(document).on('change', '.assign_user_form', function () {
                $('#pre-loader').removeClass('d-none');
                this.form.submit();
            })
        })(jQuery);

    </script>

@endpush
