<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCourseIdColumnSupportTicketsTable extends Migration
{
    public function up()
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            if (!Schema::hasColumn("support_tickets", 'course_id')) {
                $table->unsignedBigInteger('course_id')->nullable();
            }
        });

    }

    public function down()
    {
        Schema::table('support_tickets', function (Blueprint $table) {
            if (Schema::hasColumn("support_tickets", 'course_id')) {
                $table->dropColumn('course_id');
            }
        });
    }
}
