<?php

namespace Modules\Store\Repositories;

use Modules\Store\Entities\ProductUnit;


class ProductUnitRepository extends BaseRepository
{

    public function model()
    {
        return ProductUnit::class;
    }

    function getAll()
    {
        return $this->model->all();
    }

    function store($request)
    {
        try {
            $unit = new $this->model();
            if (isModuleActive('FrontendMultiLang')) {
                foreach ($request->name as $key => $name) {
                    $unit->setTranslation('name', $key, $name);
                }
            } else {
                $unit->name = $request->name;
            }

            $unit->status = 1;
            $unit->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    function update($request)
    {
        try {
            $unit = $this->model->find($request->id);
            if (isModuleActive('FrontendMultiLang')) {
                foreach ($request->name as $key => $name) {
                    $unit->setTranslation('name', $key, $name);
                }
            } else {
                $unit->name = $request->name;
            }

            $unit->save();
            return true;
        } catch (\Throwable $th) {
            return false;
        }
    }

    function destroy($id)
    {
        try {
            $unit = $this->model->find($id);
            $unit->delete();
            return true;
        } catch (\Throwable $th) {

            return false;
        }
    }
}
