<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BrandUpdateRequest extends FormRequest
{
    public function rules()
    {
        if (isModuleActive('FrontendMultiLang')) {
            $code = auth()->user()->language_code;
            return [
                'name.' . $code => ['required'],
                "status" => "required",
                'logo' => 'mimes:jpeg,jpg,png,gif|nullable'
            ];
        } else {

            return [
                "name" => 'required|unique:product_brands,name,' . $this->id,
                "status" => "required",
                'logo' => 'mimes:jpeg,jpg,png,gif|nullable'
            ];
        }
    }

    public function messages()
    {
        if (isModuleActive('FrontendMultiLang')) {
            return [
                'name.*.required' => 'The Brand name is required',
                'name.*.unique_translation' => 'The Brand name has already been taken',
            ];
        } else {
            return [
                'name.required' => 'The Brand name is required',
                'name.unique' => 'The Brand name has already been taken',
            ];
        }
    }

    public function authorize()
    {
        return true;
    }
}
