<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Entities\OrderPackageDetail;
use Modules\Store\Entities\ProductCarrier;
use Modules\Store\Entities\ShippingMethod;
use Modules\Store\Repositories\CarrierRepository;
use Modules\Store\Repositories\OrderRepository;
use Modules\Store\Repositories\PickupLocationRepository;
use Modules\Store\Repositories\ShippingRepository;
use Modules\Store\Traits\GeneratePdf;

class ShippingOrderController extends Controller
{
    use GeneratePdf;

    protected $orderRepo;
    protected $pickupLocationRepo;

    public function __construct(OrderRepository $orderRepoRepo, PickupLocationRepository $pickupLocationRepo)
    {
        $this->orderRepo = $orderRepoRepo;
        $this->pickupLocationRepo = $pickupLocationRepo;
    }

    public function index(Request $request)
    {
        try {

            $data['f_carrier'] = isset($request->carrier) ? $request->carrier : '';
            $data['shipping_method'] = isset($request->shipping_method) ? $request->shipping_method : '';
            $data['date_range_filter'] = isset($request->date_range_filter) ? $request->date_range_filter : '';
            $data['package_code'] = isset($request->package_code) ? $request->package_code : '';

            $filterData = [
                'carrier' => $data['f_carrier'],
                'shipping_method' => $data['shipping_method'],
                'date_range_filter' => $data['date_range_filter'],
                'package_code' => $data['package_code'],
            ];
            $shippingRepo = new ShippingRepository();
            $data['shipping_methods'] = $shippingRepo->getActiveAll();

            $carrierRepo = new CarrierRepository();
            $data['carriers'] = $carrierRepo->getActiveAll();
            $data['orders'] = $this->orderRepo->pendingOrder($filterData);
            $data['pickup_locations'] = $this->pickupLocationRepo->getActiveAll();

            return view('store::shipping.order.index', $data);
        } catch (\Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }

    }

    public function singleOrderMethodChange($id)
    {
        try {
            $data['row'] = OrderPackageDetail::with('product_details.getCourse')->find($id);
            $data['shipping_methods'] = ShippingMethod::where('request_by_user', auth()->user()->id)->where('is_active', 1)->where('carrier_id', $data['row']->carrier_id)->whereHas('carrier', function ($q) {
                $q->where('status', 1);
            })->with(['carrier'])->get();

            $data['couriers'] = [];
            $data['carriers'] = ProductCarrier::where('status', 1)->get();

            return view('store::order.components._single_order_method_change', $data);
        } catch (Exception $e) {
            Toastr::error($e->getMessage(), trans('common.Error'));
            return response()->json(['error' => $e->getMessage()], 503);
        }
    }

    public function labelGenerate($id)
    {
        try {
            $data['order'] = OrderPackageDetail::with('product_details.getCourse')->find($id);

            return view('store::shipping.order.label_pdf', $data);
        } catch (\Exception $e) {
            return response()->json($e);
        }

    }

    public function invoiceGenerate($id)
    {
        try {
            $data['order'] = OrderPackageDetail::with('product_details.getCourse')->find($id);
            return view('store::shipping.order.invoice_pdf', $data);

        } catch (\Exception $e) {
            return response()->json($e);
        }

    }
}
