<?php

namespace Modules\Store\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Store\Entities\ProductAuthor;
use Modules\Store\Entities\ProductPublication;
use Modules\Store\Repositories\ProductAuthorRepository;

class AuthorController extends Controller
{
    use ValidatesRequests;

    public $ProductAuthorRepository;

    public function __construct(ProductAuthorRepository $ProductAuthorRepository)
    {
        $this->ProductAuthorRepository = $ProductAuthorRepository;
    }


    public function index()
    {

        try {

            $authors = ProductAuthor::orderBy('id', 'desc')->get();
            $publications = ProductPublication::where('status', 1)->latest()->get();

            return view('store::authors.index', compact('authors', 'publications'));

        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }


    }

    public function store(Request $request)
    {
        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
            'publication_id' => 'required',
        ];


        $this->validate($request, $rules, validationMessage($rules));

        try {
            $author = $this->ProductAuthorRepository->create($request);

            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }

        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }

    }

    public function create()
    {
        return view('store::create');
    }

    public function show($id)
    {
        return view('store::show');
    }


    public function edit($id)
    {
        try {
            $edit = ProductAuthor::find($id);
            $authors = ProductAuthor::orderBy('id', 'desc')->get();
            $publications = ProductPublication::where('status', 1)->latest()->get();

            return view('store::authors.index', compact('authors', 'edit','publications'));
        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function update(Request $request)
    {


        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
            'photo' => 'mimes:jpeg,jpg,png,gif,svg|max:10000',
        ];

        $this->validate($request, $rules, validationMessage($rules));


        try {
            $author = $this->ProductAuthorRepository->update($request);

            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.author.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }

        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }

    }

    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $author = $this->ProductAuthorRepository->delete($id);
            if ($author) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }

        } catch (Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
