<?php

namespace Modules\Store\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Store\Repositories\ProductAttributeRepository;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Modules\Store\Entities\ProductAttribute;
use Modules\Store\Entities\ProductAttributeValue;

class AttributeController extends Controller
{

    use ValidatesRequests;

    public $ProductAttributeRepository;

    public function __construct(ProductAttributeRepository $ProductAttributeRepository)
    {
        $this->ProductAttributeRepository = $ProductAttributeRepository;
    }

    public function index()
    {
        try {

            $attributes = ProductAttribute::orderBy('id', 'desc')->get();

            return view('store::attributes.index', compact('attributes'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function create()
    {
        return view('store::create');
    }

    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }


        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
            'variant_values.*' => 'required|max:255',
        ];


        $this->validate($request, $rules, validationMessage($rules));

        try {
            $attribute = $this->ProductAttributeRepository->create($request);

            if ($attribute) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function show($id)
    {
        return view('store::show');
    }

    public function edit($id)
    {

        $edit = ProductAttribute::with('values')->find($id);
        $attributes = ProductAttribute::orderBy('id', 'desc')->get();

        return view('store::attributes.index', compact('attributes', 'edit'));
    }


    public function update(Request $request)
    {

        $code = auth()->user()->language_code;

        $rules = [
            'name.' . $code => 'required|max:255',
            'edit_variant_values.*' => 'required|max:255',
        ];


        $this->validate($request, $rules, validationMessage($rules));


        $attribute = $this->ProductAttributeRepository->update($request);

        if ($attribute) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.attribute.index');
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $attribute = $this->ProductAttributeRepository->delete($id);
            if ($attribute) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->route('store.attribute.index');
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function attribute_values(Request $request)
    {

        try {
            $attributeValues = ProductAttributeValue::where('product_attribute_id', $request->id)->get();

            return $attributeValues;
        } catch (\Exception $e) {
            return response()->json(["message" => "Something Went Wrong", "error" => $e->getMessage()], 503);
        }
    }
}
