<?php

namespace Modules\Store\Entities;

use Illuminate\Database\Eloquent\Model;
use Modules\CourseSetting\Entities\Course;

class OrderProductDetail extends Model
{
    protected $fillable = [];
    protected $guarded = ['id'];

    public function package()
    {
        return $this->belongsTo(OrderPackageDetail::class, 'package_id', 'id');
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id');
    }

    public function getCourse()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id');
    }

}
