<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePickupLocationsTable extends Migration
{
    public function up()
    {
        Schema::create('pickup_locations', function (Blueprint $table) {
            $table->id();
            $table->string('pickup_location')->nullable();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('address_2')->nullable();
            $table->unsignedBigInteger('city_id')->nullable();
            $table->unsignedBigInteger('state_id')->nullable();
            $table->unsignedBigInteger('country_id')->nullable();
            $table->integer('pin_code')->nullable();
            $table->float('lat')->nullable();
            $table->float('long')->nullable();
            $table->boolean('status')->default(1);
            $table->boolean('is_set')->default(0);
            $table->boolean('is_default')->default(0);
            $table->unsignedBigInteger('created_by')->nullable();
            $table->timestamps();
        });

        $sql = [
            'pickup_location' => 'Pickup Location 1',
            'name' => Settings('site_title'),
            'email' => Settings('email'),
            'phone' => Settings('phone'),
            'address' => Settings('address'),
            'country_id' => Settings('country_id'),
            'pin_code' => Settings('zip_code'),
            'is_set' => 1,
            'status' => 1,
            'created_by' => 1,
            'is_default' => 1
        ];
        DB::table('pickup_locations')->insert([$sql]);
    }


    public function down()
    {
        Schema::dropIfExists('pickup_locations');
    }
}
