<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProductOrdersTable extends Migration
{
    public function up()
    {
        Schema::create('product_orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->nullable();
            $table->integer('product_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('quantity')->nullable();
            $table->double('unit_price')->nullable();
            $table->double('total_price')->nullable();
            $table->double('discount_amount')->nullable();
            $table->double('net_price')->nullable();
            $table->integer('payment_method')->nullable();
            $table->integer('payment_status')->nullable();
            $table->integer('order_status')->nullable();
            $table->timestamp('order_date')->nullable();
            $table->date('delivery_date')->nullable();
            $table->integer('discount_assigned_by')->nullable();
            $table->string('discount_code')->nullable();
            $table->string('delivery_type')->default('home_delivery')->nullable();
            $table->unsignedBigInteger('pickup_location_id')->nullable();
            $table->integer('lms_id')->default(1);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_orders');
    }
}
