<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ModifyUsersTableForRegistrationBonus extends Migration
{
    public function up()
    {
        if (!Schema::hasColumn('users', 'total_referrer_users')) {
            Schema::table('users', function (Blueprint $table) {
                $table->integer('total_referrer_users')->default(0);
            });
        }

        if (!Schema::hasColumn('users', 'total_referrer_amount')) {
            Schema::table('users', function (Blueprint $table) {
                $table->double('total_referrer_amount')->default(0);
            });
        }
    }

    public function down()
    {
        if (Schema::hasColumn('users', 'total_referrer_users')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('total_referrer_users');
            });
        }

        if (Schema::hasColumn('users', 'total_referrer_amount')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('total_referrer_amount');
            });
        }
    }
}
