<?php

namespace Modules\Installment\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\CourseSetting\Entities\Course;
use Modules\Setting\Entities\UsedMedia;
use App\Traits\HasTranslations;

class InstallmentPlan extends Model
{
    use HasTranslations, SoftDeletes;

    protected $fillable = [];

    public $translatable = ['title', 'description'];

    public function plan_specific_item()
    {
        return $this->hasOne(PlanSpecificItem::class, 'installment_plan_id');
    }

    public function features()
    {
        return $this->hasMany(InstallmentPlanOption::class, 'installment_plan_id');
    }

    public function paymentSteps()
    {
        return $this->hasMany(InstallmentPlanPaymentStep::class, 'installment_plan_id');
    }

    public function getStatusTextAttribute()
    {
        if ($this->status == 1) {
            return _trans('common.Active');
        } else {
            return _trans('common.Inactive');
        }
    }

    public function planCapacity()
    {
        $total_capacity = $this->capacity;
        $booked = InstallmentPurchaseRequest::where('plan_id', $this->id)->whereNotIn('payment_status', ['incomplete', 'paid'])->count();
        $exist = $total_capacity - $booked;
        $exist = $exist < 0 ? 0 : $exist;
        $booked_percentage = $booked * 100 / $total_capacity;
        $exist_percentage = $exist * 100 / $total_capacity;

        $data = [];
        $data['total'] = $total_capacity;
        $data['booked'] = $booked;
        $data['exist'] = $exist;
        $data['booked_percentage'] = $booked_percentage;
        $data['exist_percentage'] = $exist_percentage;
        return $data;
    }


    public static function checkProductInstallment($product_id, $product_type)
    {
        $plan = null;

        $target_type_array = [];
        $product_info = Course::find($product_id);
        switch ($product_type) {
            case 'course':
                $target_type_array = ['all_course', 'specific_course', 'specific_category', 'specific_instructor'];
                break;
            case 'quiz':
                $target_type_array = ['all_quiz', 'specific_quiz', 'specific_instructor'];
                break;
            case 'live_class':
                $target_type_array = ['all_live_class', 'specific_class', 'specific_instructor'];
                break;

            default:

                break;
        }

        $installment_plans = InstallmentPlan::where('status', 1)->with('plan_specific_item', 'plan_specific_item.plan_specific_item_details_relation', 'features', 'paymentSteps')->get();
        if ($plan == null) {
            foreach ($installment_plans as $installment_plan) {
                if ($installment_plan->plan_specific_item->target_type == 'all') {
                    $plan = $installment_plan;
                }
                $installment_plan_target = $installment_plan->plan_specific_item->target;
                if (in_array($installment_plan_target, $target_type_array)) {
                    $assigned_items = $installment_plan->plan_specific_item->plan_specific_item_details();
                    if ($installment_plan_target == 'specific_instructor') {
                        if (in_array($product_info->user_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                    if ($installment_plan_target == 'specific_category') {
                        if (in_array($product_info->category_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                    if ($installment_plan_target == 'specific_course') {
                        if (in_array($product_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                    if ($installment_plan_target == 'specific_quiz') {
                        if (in_array($product_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                    if ($installment_plan_target == 'specific_class') {
                        if (in_array($product_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                    if (in_array($installment_plan_target, ['all_course', 'all_quiz', 'all_live_class'])) {
                        if (in_array($product_id, $assigned_items)) {
                            $plan = $installment_plan;
                        }
                    }
                }
            }
            return $plan;
        }

    }

    public function banner_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'banner');
    }

    public function verification_banner_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'verification_banner');
    }

    public function verification_video_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'verification_video');
    }

}
