<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentPurchasePaymentsTable extends Migration
{
    public function up()
    {
        Schema::create('installment_purchase_payments', function (Blueprint $table) {
            $table->id();
            $table->integer('installment_purchase_id');
            $table->enum('type', ['upfront', 'step']);
            $table->integer('step_id')->unsigned()->nullable();
            $table->float('amount', 15, 2);
            $table->string('amount_type')->nullable()->comment('percent or fixed');
            $table->float('percentage', 15, 2)->nullable();
            $table->date('due_date')->nullable();
            $table->date('payment_date')->nullable();
            $table->boolean('is_overdue')->default(0);
            $table->string('status')->default('pending')->nullable();


            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('installment_purchase_payments');
    }
}
