<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInstallmentPlanPaymentStepsTable extends Migration
{
    public function up()
    {
        Schema::create('installment_plan_payment_steps', function (Blueprint $table) {
            $table->id();
            $table->integer('installment_plan_id')->nullable();
            $table->string('payment_title')->nullable();
            $table->integer('payment_deadline')->nullable()->comment('in days');
            $table->double('payment_amount')->nullable();
            $table->string('amount_type')->nullable()->comment('fixed_amount,percent');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('installment_plan_payment_steps');
    }
}
