<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddGiftPermissions extends Migration
{
    public function up()
    {
        $routes = [
            ['name' => "Send Gifts", 'route' => 'gift', 'type' => 1, 'parent_route' => null, 'module' => 'Gift'],
            ['name' => 'Gifts List', 'route' => 'gift.list', 'type' => 2, 'parent_route' => 'gift', 'module' => 'Gift'],
            ['name' => 'Settings', 'route' => 'gift.settings', 'type' => 2, 'parent_route' => 'gift', 'module' => 'Gift'],
            ['name' => 'Invitation', 'route' => 'gift.send_invitation', 'type' => 3, 'parent_route' => 'gift.list', 'module' => 'Gift'],
            ['name' => 'Delete', 'route' => 'gift.delete', 'type' => 3, 'parent_route' => 'gift.list', 'module' => 'Gift'],
        ];

        if (function_exists('permissionUpdateOrCreate')) {
            permissionUpdateOrCreate($routes);
        }
    }

    public function down()
    {
        //
    }
}
