<?php

namespace Modules\Cashback\Http\Requests;

use Illuminate\Http\Request;
use Illuminate\Foundation\Http\FormRequest;

class CashbackRuleRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function messages()
    {

        return  validationMessage($this->rules());
    }


    public function rules()
    {
        $code = auth()->user()->language_code;

        if (Request::route()->getName() == "installment.plan.update") {
            return [
                'title.' . $code => 'required|max:255',
                "start_date"=>"required",
                "start_time"=>"required",
                "target_type"=>"required",
                "target" => "required_unless:target_type,all|nullable",
                "specific_user" => "required_if:user_type,==,specific_user",
                "end_date"=>"sometimes|required|after_or_equal:start_date",
                'end_time'=>"required",
                "min_purchase_amount"=>"required",
                "amount"=>"required",
                "amount_type"=>"required",

            ];
        }else{
            return [
                'title.' . $code => 'required|max:255',
                "start_date"=>"required",
                "start_time"=>"required",
                "target_type"=>"required",
                "target" => "required_unless:target_type,all|nullable",
                "specific_user" => "required_if:user_type,==,specific_user",
                "end_date"=>"sometimes|required|after_or_equal:start_date",
                'end_time'=>"required",
                "min_purchase_amount"=>"required",
                "amount"=>"required",
                "amount_type"=>"required",

            ];
        }

    }

}
