<?php

namespace Modules\BundleSubscription\Database\Seeders;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use Modules\BundleSubscription\Entities\BundleCourse;
use Modules\BundleSubscription\Entities\BundleCoursePlan;

class BundleSubscriptionDatabaseSeeder extends Seeder
{
    public function run()
    {
        Model::unguard();

//        bundle_course_plans
        $plan1 = BundleCoursePlan::create([
            'title' => 'Basic',
            'price' => 10,
            'days' => 30,
            'button_text' => 'Buy now',
            'user_id' => 2,
            'status' => 1,
        ]);

        $plan2 = BundleCoursePlan::create([
            'title' => 'Pro',
            'price' => 100,
            'days' => 90,
            'button_text' => 'Buy now',
            'user_id' => 1,
            'status' => 1,
        ]);

        $plan3 = BundleCoursePlan::create([
            'title' => 'Unlimited',
            'price' => 1000,
            'days' => null,
            'button_text' => 'Buy now',
            'user_id' => 1,
            'status' => 1,
        ]);
        $plan4 = BundleCoursePlan::create([
            'title' => 'Enterprise',
            'price' => 5000,
            'days' => null,
            'button_text' => 'Buy now',
            'user_id' => 1,
            'status' => 1,
        ]);
        $assign = [
            [
                'plan_id' => $plan1->id,
                'course_id' => 1,
            ],
            [
                'plan_id' => $plan1->id,
                'course_id' => 2,
            ],
            [
                'plan_id' => $plan1->id,
                'course_id' => 3,
            ],
            [
                'plan_id' => $plan1->id,
                'course_id' => 4,
            ],
            [
                'plan_id' => $plan1->id,
                'course_id' => 5,
            ],

            [
                'plan_id' => $plan2->id,
                'course_id' => 6,
            ],
            [
                'plan_id' => $plan2->id,
                'course_id' => 7,
            ],

            [
                'plan_id' => $plan2->id,
                'course_id' => 8,
            ],
            [
                'plan_id' => $plan2->id,
                'course_id' => 9,
            ],
            [
                'plan_id' => $plan2->id,
                'course_id' => 10,
            ],
            [
                'plan_id' => $plan3->id,
                'course_id' => 11,
            ],
            [
                'plan_id' => $plan3->id,
                'course_id' => 12,
            ],
            [
                'plan_id' => $plan3->id,
                'course_id' => 13,
            ],
            [
                'plan_id' => $plan3->id,
                'course_id' => 14,
            ],
            [
                'plan_id' => $plan3->id,
                'course_id' => 15,
            ], [
                'plan_id' => $plan4->id,
                'course_id' => 16,
            ],
            [
                'plan_id' => $plan4->id,
                'course_id' => 17,
            ],
            [
                'plan_id' => $plan4->id,
                'course_id' => 18,
            ],
            [
                'plan_id' => $plan4->id,
                'course_id' => 19,
            ],
            [
                'plan_id' => $plan4->id,
                'course_id' => 20,
            ],


        ];
        BundleCourse::insert($assign);

    }
}
