@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {{generateBreadcrumb()}}
    <style>
        .assignment_info {
            margin-top: 10px;
        }
    </style>
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box ">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-flex flex-wrap mb-0">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                            id="page_title">{{__('assignment.Assignment')}} {{__('common.Details')}}</h3>

                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row assignment_info">
                            <div class="col-lg-2">
                                <label class="primary_input_label" for="title"><b>{{ __('common.Title') }}</b></label>
                            </div>
                            <div class="col-lg-4">
                                : {{@$assignment_info->title}}
                            </div>
                            <div class="col-lg-2">
                                <b>{{__('courses.Course')}}</b>
                            </div>
                            <div class="col-lg-4">
                                @if ($assignment_info?->course?->title)
                                    : {{@$assignment_info?->course?->title}}
                                @else
                                    : {{__('assignment.Not Assigned')}}
                                @endif

                            </div>
                        </div>
                        <div class="row assignment_info">
                            <div class="col-lg-2">
                                <b>{{ __('assignment.Marks') }}</b>
                            </div>
                            <div class="col-lg-4">
                                : {{@$assignment_info->marks}}
                            </div>
                            <div class="col-lg-2">
                                <b>{{ __('assignment.Min Percentage') }}</b>
                            </div>
                            <div class="col-lg-4">
                                : {{@$assignment_info->min_parcentage}}%
                            </div>
                        </div>
                        <div class="row assignment_info">
                            <div class="col-lg-2">
                                <b>{{ __('assignment.Submit Date') }}</b>
                            </div>
                            <div class="col-lg-4">
                                : {{showDate(@$assignment_info->last_date_submission)}}
                            </div>
                            @if (file_exists($assignment_info->attachment))

                                <div class="col-lg-2">
                                    {{__('assignment.Attachment')}}
                                </div>
                                <div class="col-lg-4">
                                    : <a href="{{asset(@$assignment_info->attachment)}}"
                                         download="{{@$assignment_info->title}}_attachment">{{__('common.Download')}}</a>
                                </div>
                            @endif
                        </div>
                        <div class="row assignment_info mt-4">
                            <div class="col-lg-2">
                                <b class="mb-2 d-block">{{__('assignment.Description')}}</b>
                            </div>
                            <div class="col-lg-12">
                                {!! @$assignment_info->description !!}
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_st_admin_visitor mt-20">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">

                    <div class="col-lg-12 ">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-3 mr-30 mb_xs_15px mb_sm_20px">{{__('assignment.Assignment List')}}</h3>

                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Name') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('assignment.Marks') }}</th>
                                            <th scope="col">{{ __('assignment.Submit Date') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($assigned as $key => $assign)
                                            @php
                                                $submit_info=Modules\Assignment\Entities\InfixAssignAssignment::assignmentLastSubmitted($assign->id);
                                            @endphp

                                            <tr>
                                                <td>
                                                    {{$key+1}}
                                                </td>
                                                <td>
                                                    {{@$assign->student->name}}
                                                </td>

                                                <td>
                                                    @if($submit_info)
                                                        @if ($assign->pass_status==1)
                                                            {{__('assignment.Pass')}}
                                                        @elseif($assign->pass_status==2)
                                                            {{__('assignment.Fail')}}
                                                        @else
                                                            {{__('assignment.Not Marked')}}
                                                        @endif
                                                    @else
                                                        {{__('assignment.Not Submitted')}}
                                                    @endif

                                                </td>
                                                <td>
                                                    {{@$assign->obtain_marks}}
                                                </td>
                                                <td>
                                                    @if ($submit_info!=null)
                                                        {{showDate(@$submit_info->created_at)}}
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($submit_info!=null)

                                                        <div class="dropdown CRM_dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle"
                                                                    type="button"
                                                                    id="dropdownMenu2{{@$assign->id }}"
                                                                    data-bs-toggle="dropdown"
                                                                    aria-haspopup="true"
                                                                    aria-expanded="false">
                                                                {{ __('common.Select') }}
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right"
                                                                 aria-labelledby="dropdownMenu2{{@$assign->id }}">
                                                                <a class="dropdown-item"
                                                                   data-bs-toggle="modal"
                                                                   data-bs-target="#viewAttachment{{$assign->id}}"
                                                                   href="#">{{__('common.View')}}</a>

                                                            </div>
                                                        </div>
                                                    @endif
                                                </td>

                                            </tr>
                                            @if ($submit_info!=null)
                                                @include('assignment::attachment_marking')
                                            @endif

                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <div id="edit_form">

    </div>
    <div id="view_details">

    </div>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')

@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}"></script>

    <script>

        (function ($) {
            "use strict";
            $(document).ready(function () {
                $("body").on("click", ".modalLink", function (e) {

                    e.preventDefault();
                    $(".modal-backdrop").show();
                    $("#showDetaildModal").show();
                    $("div.modal-dialog").removeClass("modal-md");
                    $("div.modal-dialog").removeClass("modal-lg");
                    $("div.modal-dialog").removeClass("modal-bg");
                    var modal_size = $(this).attr("data-modal-size");
                    if (
                        modal_size !== "" &&
                        typeof modal_size !== typeof undefined &&
                        modal_size !== false
                    ) {
                        $("#modalSize").addClass(modal_size);
                    } else {
                        $("#modalSize").addClass("modal-md");
                    }
                    var title = $(this).attr("title");
                    $("#showDetaildModalTile").text(title);
                    var data_title = $(this).attr("data-original-title");
                    $("#showDetaildModalTile").text(data_title);
                    $("#showDetaildModal").modal("show");
                    $("div.ajaxLoader").show();
                    $.ajax({
                        type: "GET",
                        url: $(this).attr("href"),
                        success: function (data) {
                            $("#showDetaildModalBody").html(data);
                            $("#showDetaildModal").modal("show");
                        },
                    });
                    console.log(e);
                });
            });
        })(jQuery);

    </script>
@endpush
