<?php

namespace Modules\Assignment\Entities;

use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class InfixAssignAssignment extends Model
{
    use Tenantable;

    protected $guarded = [];

    public function assignment()
    {
        return $this->belongsTo(InfixAssignment::class, 'assignment_id', 'id')->withDefault();
    }

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id', 'id')->withDefault();
    }

    public function assignmentSubmitted()
    {
        return $this->hasMany(InfixSubmitAssignment::class, 'assign_id');
    }

    static function assignmentLastSubmitted($assign_id)
    {
        $submitted_answer = InfixSubmitAssignment::where('assign_id', $assign_id)->orderBy('id', 'desc')->first();
        if ($submitted_answer) {
            return $submitted_answer;
        } else {
            return null;
        }
    }
}
