@extends('appointment::layouts.master')

@section('mainContent')

    <input type="hidden" id="educationDiv" value="0">
    <input type="hidden" id="certificateDiv" value="0">
    <input type="hidden" id="experienceDiv" value="0">
    <input type="hidden" id="teachingCategoryDiv" value="0">
    <input type="hidden" id="teachingLanguageDiv" value="0">
    <section class="admin-visitor-area student-details">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-md-12">
                    <div class="main-title">
                        <h3 class="mb-10 mr-30">{{ __('common.My Profile') }}</h3>
                    </div>
                    <div class="row pt-0">
                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link {{ !isset($type) ? 'active' :'' }}" href="#profile" role="tab"
                                   data-bs-toggle="tab">{{ __('common.Profile') }} </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='education' ? 'active':'') :'' }}"
                                   href="#education" role="tab"
                                   data-bs-toggle="tab">{{ __('appointment.Education') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='certificate' ? 'active':'') :'' }}"
                                   href="#certificate" role="tab"
                                   data-bs-toggle="tab">{{ __('appointment.Certificate') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='experience' ? 'active':'') :'' }}"
                                   href="#experience" role="tab"
                                   data-bs-toggle="tab">{{ __('appointment.Experience') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='teachingCategory' ? 'active':'') :'' }}"
                                   href="#teachingCategory" role="tab"
                                   data-bs-toggle="tab">{{ __('appointment.Teaching Category') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='teachingLanguage' ? 'active':'') :'' }}"
                                   href="#teachingLanguage" role="tab"
                                   data-bs-toggle="tab">{{ __('appointment.Teaching Language') }}</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link {{ isset($type) ? ($type=='password' ? 'active':'') :'' }}"
                                   href="#password" role="tab"
                                   data-bs-toggle="tab">{{ __('common.Password') }}</a>
                            </li>

                        </ul>
                    </div>
                    <div class="white_box_30px">
                        <div class="row  mt_0_sm">
                            <!-- Start Sms Details -->
                            <div class="col-lg-12">
                                <!-- Tab panes -->
                                <div class="tab-content">
                                    <input type="hidden" name="selectTab" id="selectTab">
                                    <div role="tabpanel" class="tab-pane fade {{ !isset($type) ?  'show active' : '' }}"
                                         id="profile">
                                        <div class="QA_section QA_section_heading_custom check_box_table">
                                            <div class="QA_table ">
                                                <form action="{{ route('update_user') }}" method="POST"
                                                      enctype="multipart/form-data">
                                                    @csrf
                                                    @includeIf('appointment::instructor.inc.edit_profile', [
                                                        'editInstructor' => $user,
                                                    ])
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='education' ? 'show active':'') :'' }}"
                                         id="education">
                                        <div class="white-box ps-0 pe-0 pt-0">

                                            <form method="POST" action="{{ route('appointment.instructor.update', $user->id) }}" class="form-horizontal">
                                                @method('PUT')
                                                @csrf                                            <input type="hidden" name="type" value="education">
                                            @includeIf('appointment::instructor.inc.education', [
                                                'editInstructor' => $user])
                                            <div class="col-12 mt-25">
                                                <div class="submit_btn text-center">
                                                    <button class="primary-btn fix-gr-bg" type="submit"><i
                                                            class="ti-check"></i>
                                                        {{ __('common.Update') }} </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='certificate' ? 'show active':'') :'' }}"
                                         id="certificate">
                                        <div class="QA_section QA_section_heading_custom check_box_table   ">
                                            <div class="QA_table ">


                                                <form method="POST" action="{{ route('appointment.instructor.update', $user->id) }}" class="form-horizontal">
                                                    @method('PUT')
                                                    @csrf                                                <input type="hidden" name="type" value="certificate">
                                                @includeIf('appointment::instructor.inc.certificate', [
                                                    'editInstructor' => $user,
                                                ])
                                                <div class="col-12 mt-25">
                                                    <div class="submit_btn text-center">
                                                        <button class="primary-btn fix-gr-bg" type="submit"><i
                                                                class="ti-check"></i>
                                                            {{ __('common.Update') }} </button>
                                                    </div>
                                                </div>
                                                </form>
                                            </div>


                                        </div>
                                    </div>
                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='experience' ? 'show active':'') :'' }}"
                                         id="experience">
                                        <div class="white-box ps-0 pe-0 pt-0">

                                            <form method="POST" action="{{ route('appointment.instructor.update', $user->id) }}" class="form-horizontal">
                                                @method('PUT')
                                                @csrf                                            <input type="hidden" name="type" value="experience">
                                            @includeIf('appointment::instructor.inc.work_experience', [
                                                'editInstructor' => $user,
                                            ])

                                            <div class="col-12 mt-25">
                                                <div class="submit_btn text-center">
                                                    <button class="primary-btn fix-gr-bg" type="submit"><i
                                                            class="ti-check"></i>
                                                        {{ __('common.Update') }} </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                    </div>
                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='teachingCategory' ? 'show active':'') :'' }}"
                                         id="teachingCategory">
                                        <div class="QA_section QA_section_heading_custom check_box_table   ">
                                            <div class="QA_table ">


                                                <form method="POST" action="{{ route('appointment.instructor.update', $user->id) }}" class="form-horizontal">
                                                    @method('PUT')
                                                    @csrf
                                                    @includeIf('appointment::instructor.inc.teachingCategory', [
                                                    'editInstructor' => $user,
                                                ])
                                                <input type="hidden" name="type" value="teachingCategory">
                                                <div class="col-12 mt-25">
                                                    <div class="submit_btn text-center">
                                                        <button class="primary-btn fix-gr-bg" type="submit"><i
                                                                class="ti-check"></i>
                                                            {{ __('common.Update') }} </button>
                                                    </div>
                                                </div>
                                                </form>
                                            </div>

                                        </div>
                                    </div>
                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='teachingLanguage' ? 'show active':'') :'' }}"
                                         id="teachingLanguage">
                                        <div class="white-box ps-0 pe-0 pt-0">

                                            <form method="POST" action="{{ route('appointment.instructor.update', $user->id) }}" class="form-horizontal">
                                                @method('PUT')
                                                @csrf                                            <input type="hidden" name="type" value="teachingLanguage">
                                            @includeIf('appointment::instructor.inc.teachingLanguage', [
                                                'editInstructor' => $user,
                                            ])
                                            <div class="col-12 mt-25">
                                                <div class="submit_btn text-center">
                                                    <button class="primary-btn fix-gr-bg" type="submit"><i
                                                            class="ti-check"></i>
                                                        {{ __('common.Update') }} </button>
                                                </div>
                                            </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div role="tabpanel"
                                         class="tab-pane fade {{ isset($type) ? ($type=='password' ? 'show active':'') :'' }}"
                                         id="password">
                                        <div class="white-box ps-0 pe-0 pt-0">
                                            <form action="{{ route('updatePassword') }}" method="POST">
                                                @csrf
                                                <input type="hidden" name="type" value="password">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="password-field">{{ __('common.Current') }}
                                                                {{ __('common.Password') }}
                                                                <strong class="text-danger">*</strong></label>
                                                            <div>

                                                                <input class="primary_input_field"
                                                                       name="current_password"
                                                                       {{ $errors->first('current_password') ? 'autofocus' : '' }}
                                                                       placeholder="{{ __('common.Current') }} {{ __('common.Password') }}"
                                                                       id="password-field" type="password">
                                                                <span toggle="#password-field"
                                                                      class="fa fa-fw fa-eye field-icon toggle-password"></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="password-field2">{{ __('common.New') }}
                                                                {{ __('common.Password') }}
                                                                <strong class="text-danger">*</strong></label>
                                                            <input class="primary_input_field" name="new_password"
                                                                   placeholder="{{ __('common.New') }}  {{ __('common.Password') }} {{ __('common.Minimum 8 characters') }}"
                                                                   id="password-field2" type="password"
                                                                {{ $errors->first('new_password') ? 'autofocus' : '' }}>
                                                            <span toggle="#password-field2"
                                                                  class="fa fa-fw fa-eye field-icon toggle-password2"></span>
                                                        </div>
                                                    </div>

                                                    <div class="col-md-4">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="password-field3">{{ __('common.Re-Type Password') }}
                                                                <strong class="text-danger">*</strong></label>
                                                            <input class="primary_input_field" name="confirm_password"
                                                                   {{ $errors->first('confirm_password') ? 'autofocus' : '' }}
                                                                   id="password-field3"
                                                                   placeholder="{{ __('common.Re-Type Password') }}"
                                                                   type="password">
                                                            <span toggle="#password-field3"
                                                                  class="fa fa-fw fa-eye field-icon toggle-password3"></span>
                                                        </div>
                                                    </div>


                                                    <div class="col-12 mb-10">
                                                        <div class="submit_btn text-center">
                                                            <button class="primary-btn fix-gr-bg" type="submit"><i
                                                                    class="ti-check"></i>
                                                                {{ __('common.Update') }}</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
