<div class="view_full_shedule">
    <div class="view_full_shedule_inner">
        <div class="view_full_shedule_inner_top">
            <div class="d-flex align-items-center">
                <span id='img'><img src="{{ asset($instructor->photo) }}" alt=""></span>
                <b>{{ __('appointment.Book 1-hour trial lesson') }}</b>
            </div>
            <div class="view_full_shedule_inner_top_close" id='close_shedule'><i class="ti ti-close"></i></div>
        </div>
        <div class="view_full_shedule_inner_calendar">
            <div class="view_full_shedule_inner_calendar_header">
                <button id='icon'><i class="fa fa-angle-left"></i></button>
                <span>{{ date('F j', strtotime($weekDates[0])) .' - ' .date('F j', strtotime($weekDates[6])) .' , ' .date('Y', strtotime($weekDates[0])) }}</span>
                <button id='icon'><i class="fa fa-angle-right"></i></button>

            </div>
            @php
                $tz = isset($userTimeZone) ? $userTimeZone : Settings('active_time_zone');
            @endphp
            <div class="view_full_shedule_inner_calendar_body" id="calender_body">

                @foreach ($periods as $date)
                    <div id="calender_date">
                        @php
                            $teachingInfo = Modules\Appointment\Entities\Schedule::teachingInfo('no_slot', $date->format('Y-m-d'), $instructor->id, 'get');
                        @endphp
                        <div id="header" {{ count($teachingInfo) == 0 ? 'event-offday' : '' }}>
                            <span>{{ $date->format('l') }}</span>
                            <h4>{{ $date->format('d') }}</h4>
                        </div>

                        @foreach ($teachingInfo as $scheduleInfo)
                            <div id="event_date">

                                <button class="">
                                    {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->start_time)->setTimeZone($tz)->format('h:i A') }}
                                    -
                                    {{ \Carbon\Carbon::parse($date->format('Y-m-d') . ' ' . $scheduleInfo->slotInfo->end_time)->setTimeZone($tz)->format('h:i A') }}



                                </button>

                            </div>
                        @endforeach
                    </div>
                @endforeach
            </div>
            <div class="view_full_shedule_inner_calendar_bottom">
                <p>{{ __('appointment.The calendar is in your time zone') }} {{ $tz }}</p>
                <a href="#" class="theme_btn">{{ __('appointment.Confirm time') }}</a>
            </div>
        </div>
    </div>
</div>
