<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddRolePermission extends Migration
{
    public function up()
    {
        $routes = [
            [
                'name' => 'Appointment',
                'route' => 'appointment',
                'parent_route' => null,
                'type' => 1,
                'module' => 'Appointment'
            ], [
                'name' => 'Time Slot',
                'route' => 'appointment.time-slot.index',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ], [
                'name' => 'Add',
                'route' => 'appointment.time-slot.store',
                'parent_route' => 'appointment.time-slot.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Edit',
                'route' => 'appointment.time-slot.edit',
                'parent_route' => 'appointment.time-slot.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Delete',
                'route' => 'appointment.time-slot.destroy',
                'parent_route' => 'appointment.time-slot.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Schedule',
                'route' => 'appointment.schedule.index',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Add',
                'route' => 'appointment.schedule.store',
                'parent_route' => 'appointment.schedule.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Edit',
                'route' => 'appointment.schedule.edit',
                'parent_route' => 'appointment.schedule.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Delete',
                'route' => 'appointment.schedule.destroy',
                'parent_route' => 'appointment.schedule.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Share Link',
                'route' => 'appointment.booking.shareLink',
                'parent_route' => 'appointment.schedule.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Pending Booking List',
                'route' => 'appointment.booking.index',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Approve',
                'route' => 'appointment.booking.approve',
                'parent_route' => 'appointment.booking.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Reject',
                'route' => 'appointment.booking.reject',
                'parent_route' => 'appointment.booking.index',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Trail Lesson List',
                'route' => 'appointment.booking.trail-lesson',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Booking Schedule',
                'route' => 'appointment.booking.set-schedule',
                'parent_route' => 'appointment.booking.trail-lesson',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Delete',
                'route' => 'appointment.booking.trail-lesson.delete',
                'parent_route' => 'appointment.booking.trail-lesson',
                'type' => 3,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Settings',
                'route' => 'appointment.settings.index',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ],
            [
                'name' => 'Post Request',
                'route' => 'appointment.post.list',
                'parent_route' => 'appointment',
                'type' => 2,
                'module' => 'Appointment'
            ]
        ];

        permissionUpdateOrCreate($routes);

    }

    public function down()
    {
        //
    }
}
