<div class="tab-pane fade @if(Session::has('bundle'))show active @endif " id="Bundle"
     role="tabpanel"
     aria-labelledby="General-tab">
    <div class="white-box">
        <div class="main-title mb-25">
            <h3 class="mb-0">{{__('setting.Specific Bundle Commission Setup')}} </h3>
        </div>

        <form
            action="{{route('affiliate.commission.settings.bundle')}}"
            method="post">
            @csrf
            <div class="row">

                <div class="col-lg-4 mb-10 mtr-15">
                    <div class="input-effect">
                        <label class="primary_input_label"
                               for="">{{__('affiliate.Commission Type')}} <span
                                class="required_mark_theme">*</span></label>

                        <div class="row">
                            <div class="col-md-6">
                                <label class="primary_checkbox d-flex mr-12"
                                       for="bundle_commission_type_1">
                                    <input
                                        Checked type="radio"
                                        id="bundle_commission_type_1"
                                        class="bundle_commission_type common-checkbox form-control{{ $errors->has('bundle_commission_type') ? ' is-invalid' : '' }}"
                                        name="bundle_commission_type" value="Percentage">
                                    <span
                                        class="checkmark me-2"></span> {{__('affiliate.Percentage')}}
                                </label>
                            </div>
                            <div class="col-md-6">
                                <label class="primary_checkbox d-flex mr-12"
                                       for="bundle_commission_type_2">
                                    <input
                                        type="radio"
                                        id="bundle_commission_type_2"
                                        class="bundle_commission_type common-checkbox form-control{{ $errors->has('bundle_commission_type') ? ' is-invalid' : '' }}"
                                        name="bundle_commission_type" value="Flat">
                                    <span
                                        class="checkmark me-2"></span> {{__('affiliate.Flat')}}
                                </label>
                            </div>
                        </div>


                    </div>
                </div>

                <div class="col-lg-4 mb-10">
                    <div class="input-effect">
                        <label class="mb-2">
                                                        <span
                                                            class="commissionBundleTypePercentage  ">
                                                            {{__('affiliate.Commission Percentage')}}
                                                        </span>

                            <span
                                class=" commissionBundleTypeAmount d-none">
                                                            {{__('affiliate.Commission Amount')}}
                                                        </span>

                            <span
                                class="required_mark_theme">*</span> </label>
                        <input
                            class="primary-input-field form-control{{ $errors->has('bundle_commission_amount') ? ' is-invalid' : '' }}"
                            type="number" name="bundle_commission_amount" autocomplete="off" min="0"
                            value="0">

                    </div>
                </div>

                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label"
                               for="">{{__('common.Select')}} {{__('bundleSubscription.Bundle')}}</label>
                        <select name="bundle[]"  class="multypol_check_select active mb-15"
                                multiple>
                            <option value="">{{__('common.Select')}} {{__('bundleSubscription.Bundle')}}</option>

                            @foreach ($bundles as $bundle)

                                <option value="{{@$bundle->id}}">
                                    {{@$bundle->title}}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>


                <div class="col-12 mb-10 ">
                    <div class="submit_btn text-center">
                        <button class="primary-btn fix-gr-bg" type="submit"><i
                                class="ti-check"></i> {{__('common.Update')}} {{__('setting.Setting')}}
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="col-lg-12 mt-20 p-0">
        <div class="box_header">
            <div class="main-title d-flex flex-wrap mb-0">
                <h3 class="mb-0">{{__('setting.Specific Bundle List')}}</h3>
            </div>
        </div>

        <div class="QA_section QA_section_heading_custom check_box_table">
            <div class="QA_table ">
                <!-- table-responsive -->
                <div class="">
                    <table id="lms_table" class="table Crm_table_active3">
                        <thead>
                        <tr>
                            <th scope="col"> {{__('common.SL')}} </th>
                            <th scope="col"> {{__('common.Title')}} </th>
                            <th scope="col">{{__('affiliate.Commission Type')}}</th>
                            <th scope="col">     {{__('affiliate.Amount')}} / {{__('affiliate.Percentage')}}</th>
                            <th scope="col"> {{__('common.Action')}} </th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($commissions->where('commission_for','bundle') as $key=>$commission)

                            <tr>
                                <td>{{++$key}}</td>
                                <td class="nowrap">{{@$commission->commable->title}}</td>
                                <td class="nowrap">{{@$commission->type==1?trans('affiliate.Percentage'):trans('affiliate.Flat')}}</td>
                                <td class="nowrap">{{$commission->type==1?($commission->amount.'%'):getPriceFormat($commission->amount)}}</td>
                                <td class="nowrap">

                                    <div class="dropdown CRM_dropdown">
                                        <button class="btn btn-secondary dropdown-toggle"
                                                type="button"
                                                id="dropdownMenu3{{@$commission->id}}"
                                                data-bs-toggle="dropdown"
                                                aria-haspopup="true"
                                                aria-expanded="false">
                                            {{__('common.Action')}}
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right"
                                             aria-labelledby="dropdownMenu3{{@$commission->id}}">
                                            <a class="dropdown-item btn-modal"
                                               data-container="#commonModal"
                                               href="{{route('affiliate.commission.ajaxDeleteForm',@$commission->id)}}"
                                               type="button">
                                                {{ __('common.Delete') }}</a>

                                        </div>
                                    </div>
                                </td>

                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
