@php
    use Illuminate\Support\Facades\Auth;$user = Auth::user();
    if (empty($user->referral)){
        $user->referral =generateUniqueId();
        $user->save();
    }

@endphp
<div class="white-box">

    <div class="row">
        <div class="col-lg-12">
            <div class="main-title">
                <h3 class="mb-20">
                    @if(isset($row))
                        {{__('affiliate.Update Affiliate Link')}}
                    @else
                        {{__('affiliate.Create Affiliate Link')}}
                    @endif
                </h3>
            </div>
            @if(isset($row))
                <form class="form-horizontal" method="PUT"
                      action="{{ route('affiliate.my_affiliate.update', $row->id) }}" enctype="multipart/form-data">
                    @csrf
                    @else
                        <form class="form-horizontal" method="POST" action="{{ route('affiliate.my_affiliate.store') }}"
                              enctype="multipart/form-data">
                            @csrf
                            @endif
                            <div>
                                <div class="add-visitor">
                                    <div class="row">

                                        <div class="col-lg-12 mb-30">
                                            <div class="input-effect">
                                                <label class="primary_input_label"
                                                       for="">{{__('common.Type')}} <span
                                                        class="required_mark_theme">*</span></label>

                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <label class="primary_checkbox d-flex mr-12 mb-2 text-nowrap"
                                                               for="commission_type_1">
                                                            <input
                                                                {{old('commission_type','common')=='common'? 'checked' :''}} type="radio"
                                                                id="commission_type_1"
                                                                class="commission_type common-checkbox form-control "
                                                                name="commission_type" value="common">
                                                            <span
                                                                class="checkmark me-2"></span> {{__('common.Common')}}
                                                        </label>
                                                    </div>

                                                    <div class="col-md-12">
                                                        <label class="primary_checkbox d-flex mr-12 mb-2 text-nowrap"
                                                               for="commission_type_2">
                                                            <input
                                                                {{old('commission_type')=='course'? 'checked' :''}} type="radio"
                                                                id="commission_type_2"
                                                                class="commission_type common-checkbox form-control "
                                                                name="commission_type" value="course">
                                                            <span
                                                                class="checkmark me-2"></span> {{__('affiliate.Specific Course')}}
                                                        </label>
                                                    </div>
                                                    @if(isModuleActive('BundleSubscription'))
                                                        <div class="col-md-12">
                                                            <label
                                                                class="primary_checkbox d-flex mr-12 mb-2 text-nowrap"
                                                                for="commission_type_3">
                                                                <input
                                                                    {{old('commission_type')=='bundle'? 'checked' :''}} type="radio"
                                                                    id="commission_type_3"
                                                                    class="commission_type common-checkbox form-control "
                                                                    name="commission_type" value="bundle">
                                                                <span
                                                                    class="checkmark me-2"></span> {{__('affiliate.Specific Bundle')}}
                                                            </label>
                                                        </div>
                                                    @endif
                                                    @if(isModuleActive('Subscription'))

                                                        <div class="col-md-12">
                                                            <label
                                                                class="primary_checkbox d-flex mr-12 mb-2 text-nowrap"
                                                                for="commission_type_4">
                                                                <input
                                                                    {{old('commission_type')=='subscription'? 'checked' :''}} type="radio"
                                                                    id="commission_type_4"
                                                                    class="commission_type common-checkbox form-control "
                                                                    name="commission_type" value="subscription">
                                                                <span
                                                                    class="checkmark me-2"></span> {{__('affiliate.Specific Subscription')}}
                                                            </label>
                                                        </div>
                                                    @endif

                                                </div>


                                            </div>
                                        </div>
                                        <div
                                            class="col-lg-12 mb-30 common   {{old('commission_type','common')=='common'? '' :'d-none'}}">
                                            <div class="input-effect">
                                                <label class="mb-2"> {{__('affiliate.Enter URL')}} <span
                                                        class="required_mark_theme">*</span>
                                                </label>
                                                <input
                                                    class="primary-input-field form-control{{ $errors->has('url') ? ' is-invalid' : '' }}"
                                                    type="text" id="url" name="url" autocomplete="off"
                                                    value="{{old('url',isset($row)? $row->url : '') }}">

                                                <span class="focus-border"></span>
                                                @if ($errors->has('url'))
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $errors->first('url') }}</strong>
                                                     </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div
                                            class="col-lg-12 mb-30 course   {{old('commission_type')=='course'? '' :'d-none'}}">
                                            <div class="input-effect">
                                                <label class="mb-2"> {{__('common.Select')}}  {{__('common.Course')}}
                                                    <span
                                                        class="required_mark_theme">*</span>
                                                </label>
                                                <select name="course[]" class="multypol_check_select active mb-15"
                                                        multiple>
                                                    @foreach ($courses as $key => $course)
                                                        <option value="{{ $course->id }}">{{ $course->title }}</option>
                                                    @endforeach
                                                </select>

                                                <span class="focus-border"></span>
                                                @if ($errors->has('course'))
                                                    <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $errors->first('course') }}</strong>
                                                     </span>
                                                @endif
                                            </div>
                                        </div>
                                        @if(isModuleActive('BundleSubscription'))
                                            <div
                                                class="col-lg-12 mb-30 bundle   {{old('commission_type')=='bundle'? '' :'d-none'}}">
                                                <div class="input-effect">
                                                    <label
                                                        class="mb-2"> {{__('common.Select')}}  {{__('bundleSubscription.Bundle Subscription')}}
                                                        <span
                                                            class="required_mark_theme">*</span>
                                                    </label>
                                                    <select name="bundle[]" class="multypol_check_select active mb-15"
                                                            multiple>
                                                        @foreach ($bundles as $key => $bundle)
                                                            <option
                                                                value="{{ $bundle->id }}">{{ $bundle->title }}</option>
                                                        @endforeach
                                                    </select>

                                                    <span class="focus-border"></span>
                                                    @if ($errors->has('bundle'))
                                                        <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $errors->first('bundle') }}</strong>
                                                     </span>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                        @if(isModuleActive('Subscription'))
                                            <div
                                                class="col-lg-12 mb-30 subscription   {{old('commission_type')=='subscription'? '' :'d-none'}}">
                                                <div class="input-effect">
                                                    <label
                                                        class="mb-2"> {{__('common.Select')}}  {{__('subscription.Subscription')}}
                                                        <span
                                                            class="required_mark_theme">*</span>
                                                    </label>
                                                    <select name="subscription[]"
                                                            class="multypol_check_select active mb-15"
                                                            multiple>
                                                        @foreach ($plans as $key => $plan)
                                                            <option value="{{ $plan->id }}">{{ $plan->title }}</option>
                                                        @endforeach
                                                    </select>

                                                    <span class="focus-border"></span>
                                                    @if ($errors->has('subscription'))
                                                        <span class="invalid-feedback" role="alert">
                                                        <strong>{{ $errors->first('subscription') }}</strong>
                                                     </span>
                                                    @endif
                                                </div>
                                            </div>
                                        @endif
                                    </div>

                                    <div class="row  ">
                                        <div class="col-lg-12 text-center">
                                            <button type="submit" class="primary-btn fix-gr-bg submit">

                                                <i class="ti-check"></i>
                                                @if(isset($row))
                                                    {{__('common.Update')}}
                                                @else
                                                    {{__('common.Save')}}
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
        </div>
    </div>
</div>
<script>
    (function ($) {
        "use strict";
        $(document).on('change', '.commission_type', function (event) {
            let type = $(this).val();
            if (type === 'common') {
                $('.common').removeClass('d-none');
                $('.course').addClass('d-none');
                $('.bundle').addClass('d-none');
                $('.subscription').addClass('d-none');
            } else if (type === 'course') {
                $('.common').addClass('d-none');
                $('.course').removeClass('d-none');
                $('.bundle').addClass('d-none');
                $('.subscription').addClass('d-none');
            } else if (type === 'bundle') {
                $('.common').addClass('d-none');
                $('.course').addClass('d-none');
                $('.bundle').removeClass('d-none');
                $('.subscription').addClass('d-none');
            } else if (type === 'subscription') {
                $('.common').addClass('d-none');
                $('.course').addClass('d-none');
                $('.bundle').addClass('d-none');
                $('.subscription').removeClass('d-none');
            }
        });
    })(jQuery);
</script>
