<?php

use Modules\WhatsappSupport\Http\Controllers\AgentController;
use Modules\WhatsappSupport\Http\Controllers\MessageController;
use Modules\WhatsappSupport\Http\Controllers\SettingsController;

Route::prefix('whatsapp-support')->middleware(['auth', 'admin'])->group(function () {
    Route::get('settings', [SettingsController::class, 'index'])->name('whatsapp-support.settings');
    Route::post('settings', [SettingsController::class, 'update'])->name('whatsapp-support.settings.update')->middleware('demo');

    Route::get('agents', [AgentController::class, 'index'])->name('whatsapp-support.agents');
    Route::get('agents/create', [AgentController::class, 'create'])->name('whatsapp-support.agents.create');
    Route::post('agents/store', [AgentController::class, 'store'])->name('whatsapp-support.agents.store')->middleware('demo');
    Route::post('agents/update', [AgentController::class, 'update'])->name('whatsapp-support.agents.update')->middleware('demo');
    Route::get('agents/show/{id}', [AgentController::class, 'show'])->name('whatsapp-support.agents.show');
    Route::get('agents/delete/{id}', [AgentController::class, 'destroy'])->name('whatsapp-support.agents.delete')->middleware('demo');


    Route::get('analytics', [MessageController::class, 'analytics'])->name('whatsapp-support.analytics');

});
Route::post('whatsapp-support/message/send', [MessageController::class, 'send'])->name('whatsapp-support.message.send');
