@extends('backend.master')

@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">

                    <div class="white-box   ">

                        <form action="{{route('admin.two_fa.settings.update')}}" method="POST"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="row">


                                <div class="col-md-3 mb-3">
                                    <div class="checkbox_wrap d-flex align-items-center ">
                                        <label for="enable_two_fa" class="switch_toggle me-2">
                                            <input
                                                {{Settings('enable_two_fa') == 1 ?'checked':""}} type="checkbox"
                                                id="enable_two_fa" value="1" name="enable_two_fa">
                                            <i class="slider round"></i>
                                        </label>
                                        <label
                                            class="mb-0">  {{ __('setting.Enable 2FA') }} <br>
                                        <small>[{{$roles}}]</small>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <div class="checkbox_wrap d-flex align-items-center ">
                                        <label for="enable_student_two_fa" class="switch_toggle me-2">
                                            <input
                                                {{Settings('enable_student_two_fa') == 1 ?'checked':""}} type="checkbox"
                                                id="enable_student_two_fa" value="1" name="enable_student_two_fa">
                                            <i class="slider round"></i>
                                        </label>
                                        <label
                                            class="mb-0">  {{ __('setting.Enable 2FA') }} <br>
                                        <small> [{{__('common.Student')}}]</small>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <div class="checkbox_wrap d-flex align-items-center ">
                                        <label for="force_two_fa" class="switch_toggle me-2">
                                            <input
                                                {{Settings('force_two_fa') == 1 ?'checked':""}} type="checkbox"
                                                id="force_two_fa" value="1" name="force_two_fa">
                                            <i class="slider round"></i>
                                        </label>
                                        <label
                                            class="mb-0">  {{ __('setting.Force OTP') }}</label>
                                    </div>
                                </div>

                                <div class="col-md-3 mb-3">

                                    <div class="row row-gap-10">
                                        <div class="col-lg-12">
                                            <label class="primary_input_label mt-1">{{ __('setting.Default OTP Method') }} <span
                                                    class="required_mark">*</span></label>
                                        </div>

                                        <div class="col-md-4">
                                            <label for="default_two_fa0"
                                                   class="primary_checkbox d-flex mr-12">
                                                <input type="radio" name="default_two_fa"
                                                       id="default_two_fa0" value="0"
                                                       {{Settings('default_two_fa') == 0 || empty(Settings('default_two_fa'))  || !Settings('default_two_fa') ?'checked':""}}
                                                       class="common-radio default_two_fa0 relationButton">
                                                <span
                                                    class="checkmark me-2"></span> {{ __('setting.None') }}
                                            </label>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="default_two_fa1"
                                                   class="primary_checkbox d-flex mr-12">
                                                <input type="radio" name="default_two_fa"
                                                       id="default_two_fa1" value="1"
                                                       {{Settings('default_two_fa') == 1 ?'checked':""}}
                                                       class="common-radio default_two_fa1 relationButton">
                                                <span
                                                    class="checkmark me-2"></span> {{ __('setting.Email') }}
                                            </label>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="default_two_fa3"
                                                   class="primary_checkbox d-flex mr-12">
                                                <input type="radio" name="default_two_fa"
                                                       id="default_two_fa3" value="3"
                                                       {{Settings('default_two_fa') == 3 ?'checked':""}}
                                                       class="common-radio default_two_fa3 relationButton">

                                                <span
                                                    class="checkmark me-2"></span> {{ __('setting.SMS') }}
                                            </label>
                                        </div>
                                    </div>

                                </div>

                            </div>


                            <div class="row">

                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center ">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                data-bs-toggle="tooltip"
                                                id="save_button_parent">
                                            <i class="ti-check"></i>
                                            {{ __('common.Update') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>

@endsection

