<?php

namespace Modules\Tax\Http\Controllers;

use App\Country;
use App\Http\Controllers\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Modules\Tax\Entities\CountryWishTax;

class TaxController extends Controller
{
    public function index()
    {
        $countries = Country::where('active_status', 1)->select('name', 'id', 'active_status')->get();
        $taxs = CountryWishTax::all();
        return view('tax::country_wish', compact('countries', 'taxs'));
    }


    public function store(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $rules = [
            'country_id' => 'required|unique:country_wish_taxes,country_id',
            'tax' => 'required|numeric|min:0|max:100',
            'status' => 'required|numeric',

        ];
        $this->validate($request, $rules, validationMessage($rules));

        try {
            $tax = new CountryWishTax();
            $tax->country_id = $request->country_id;
            $tax->tax = $request->tax;
            $tax->status = $request->status;
            $tax->save();
            Cache::forget('countryWishTaxList_'.SaasDomain());

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());

        }
    }


    public function edit($id)
    {
        $edit = CountryWishTax::findOrFail($id);
        $countries = Country::where('active_status', 1)->select('name', 'id', 'active_status')->get();
        $taxs = CountryWishTax::all();
        return view('tax::country_wish', compact('countries', 'taxs', 'edit'));
    }


    public function update(Request $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $tax = CountryWishTax::findOrFail($request->id);

        $rules = [
            'country_id' => 'required|unique:country_wish_taxes,country_id,' . $request->id,
            'tax' => 'required|numeric|min:0|max:100',
            'status' => 'required|numeric',

        ];
        $this->validate($request, $rules, validationMessage($rules));
        try {

            $tax->country_id = $request->country_id;
            $tax->tax = $request->tax;
            $tax->status = $request->status;
            $tax->save();
            Cache::forget('countryWishTaxList_'.SaasDomain());
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->to(route('tax.country-wish-tax.index'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }

    public function delete($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {
            CountryWishTax::findOrFail($id)->delete();
            Cache::forget('countryWishTaxList_'.SaasDomain());

            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
