@extends('backend.master')
@php
    $table_name='survey_question_sets';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center mt-50">
                <div class="col-lg-3">
                    <div class="main-title">
                        <h3 class="mb-20"> @if (isset($edit))
                                {{ __('common.Update') }}
                            @else
                                {{ __('common.Add') }}
                            @endif  {{__('survey.Answer Set')}} </h3>
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            @if (isset($edit) && permissionCheck('survey.set_update'))
                                <form method="POST" action="{{ route('survey.set_update') }}" accept-charset="UTF-8"
                                      class="form-horizontal" enctype="multipart/form-data">
                                    <input type="hidden" name="id" value="{{$edit->id}}">
                                    @else
                                        @if (permissionCheck('survey.set_store'))
                                            <form method="POST" action="{{ route('survey.set_store') }}"
                                                  accept-charset="UTF-8" class="form-horizontal"
                                                  enctype="multipart/form-data">

                                                @endif
                                                @endif

                                                @csrf
                                                <div class="white-box">

                                                    <div class="add-visitor">
                                                        <div class="row">
                                                            <div class="col-lg-12">
                                                                <div class="input-effect">
                                                                    <label class="primary_input_label mt-1">Name <span
                                                                            class="text-danger">*</span></label>
                                                                    <input class="primary_input_field" type="text"
                                                                           name="name" autocomplete="off"
                                                                           value="{{ isset($edit) ? $edit->name: old('name')}}">
                                                                </div>
                                                            </div>

                                                            <div class="col-lg-12">
                                                                <div class="input-effect">
                                                                    <label class="primary_input_label mt-1">Answer Type <span
                                                                            class="text-danger">*</span></label>
                                                                    <select name="answer_type" id="type"
                                                                            class="primary_select">
                                                                        <option value="" selected>Choose</option>
                                                                        <option
                                                                            {{ isset($edit) ? $edit->answer_type=='checkbox'?'selected':'':''}} value="checkbox">
                                                                            Checkbox
                                                                        </option>
                                                                        <option
                                                                            {{ isset($edit) ? $edit->answer_type=='dropdown'?'selected':'':''}} value="dropdown">
                                                                            Dropdown
                                                                        </option>
                                                                        <option
                                                                            {{ isset($edit) ? $edit->answer_type=='radio'?'selected':'':''}} value="radio">
                                                                            Radio
                                                                        </option>
                                                                        {{-- <option {{ isset($edit) ? $edit->answer_type=='textarea'?'selected':'':''}} value="textarea">Textarea</option> --}}
                                                                    </select>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row mt-40">
                                                            <div class="col-lg-12 text-center">
                                                                <button type="submit" class="primary-btn fix-gr-bg"
                                                                        data-bs-toggle="tooltip" title=""><span
                                                                        class="ti-check"></span> Save
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-lg-9">

                    <div class="main-title">
                        <h3 class="mb-20">{{__('survey.Answer Set')}}</h3>
                    </div>

                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table Crm_table_active3">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{__('common.SL')}}</th>
                                        <th scope="col">{{__('common.Name')}}</th>
                                        <th scope="col">{{__('common.Type')}}</th>
                                        <th scope="col">{{__('common.Status')}}</th>
                                        <th scope="col">{{__('common.Action')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($sets as $index => $set)
                                        <tr>
                                            <td scope="col">{{ $index+1 }}</td>
                                            <td scope="col">{{ $set->name }}</td>
                                            <td scope="col">{{ ucfirst($set->answer_type) }}</td>
                                            <td class="nowrap">
                                                @if (Auth::user()->role_id==1)
                                                    <label class="switch_toggle ml-20" for="status{{$set->id}}">
                                                        <input type="checkbox" class="status_enable_disable"
                                                               name="status" id="status{{$set->id}}"
                                                               {{$set->status==1? 'checked':''}}  value="{{$set->id}}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                @else
                                                    @if ($set->status==1)
                                                        Enabled
                                                    @else
                                                        Disabled

                                                    @endif
                                                @endif
                                            </td>
                                            <td scope="col">
                                                <div class="dropdown CRM_dropdown">
                                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                                            id="dropdownMenu2" data-bs-toggle="dropdown"
                                                            aria-haspopup="true" aria-expanded="false">
                                                        Action
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-right"
                                                         aria-labelledby="dropdownMenu2" style="">
                                                        @if (permissionCheck('survey.set_update'))
                                                            <a href="{{ route('survey.set_edit', $set->id) }}"
                                                               class="dropdown-item editStudent"
                                                               type="button">{{__('common.Edit')}}</a>
                                                        @endif
                                                        @if (permissionCheck('survey.set_delete'))
                                                            <a onclick="confirm_modal('{{route('survey.set_delete', $set->id)}}');"
                                                               class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                        @endif
                                                        @if (permissionCheck('survey.set_delete'))
                                                            <a href="{{ route('survey.set_attribute', $set->id) }}"
                                                               class="dropdown-item editStudent"
                                                               type="button">Attribute</a>
                                                        @endif

                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Add Modal Item_Details -->
            </div>
        </div>
    </section>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')
@endsection

