<?php

namespace Modules\Subscription\Entities;

use App\BillingDetails;
use App\Traits\Tenantable;
use App\User;
use Illuminate\Database\Eloquent\Model;

class SubscriptionCheckout extends Model
{
    use Tenantable;

    protected $fillable = [];

    public function plan()
    {
        return $this->belongsTo(CourseSubscription::class, 'plan_id')->withDefault();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id')->withDefault();
    }

    public function billing()
    {
        return $this->belongsTo(BillingDetails::class, 'billing_detail_id')->withDefault();
    }
}
