@extends('backend.master')
@section('mainContent')
    @php
        $url = route('refund.all_refund_request_data');
    @endphp
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                id="page_title"> {{ __('product.pending_refund_requests') }}</h3>
                        </div>
                    </div>
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <table id="lms_table" class="table classList">
                                <thead>
                                <tr>
                                    <th scope="col"> {{ __('common.SL') }}</th>
                                    <th scope="col"> {{ __('common.date') }}</th>
                                    <th>{{ __('product.order_id') }}</th>
                                    <th>{{ __('common.Email') }}</th>
                                    <th>{{ __('product.total_amount') }}</th>
                                    <th>{{ __('product.request_status') }}</th>
                                    <th>{{ __('product.is_refunded') }}</th>
                                    <th scope="col">{{ __('common.Action') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('scripts')

    <script>

        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = '{!! $url !!}';
            dataTableOptions.columns = [{
                data: 'DT_RowIndex',
                name: 'id'
            },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'order_id',
                    name: 'order_id'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'total_amount',
                    name: 'total_amount'
                },
                {
                    data: 'request_status',
                    name: 'request_status'
                },
                {
                    data: 'is_refunded',
                    name: 'is_refunded'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false
                },

            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);

    </script>
@endpush
