<div class="modal-dialog modal-dialog-centered modal_800px">
    <div class="modal-content">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">{{ $product->course->title }} {{ __('product.details') }}</h4>
                <button type="button" class="close " data-bs-dismiss="modal">
                    <i class="ti-close "></i>
                </button>
            </div>
            <div class="modal-body">
                <form action="">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="products_view_left text-center mb-35">
                                <div class="products_image_div mb-25">
                                    <img src="{{ showImage($product->course->image) }}" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="products_view_right mb-35">
                                <div class="products_details_list">
                                    <div class="products_details_single">
                                        <span>{{__('common.Name')}}: </span>
                                        <span>{{ $product->course->title }}</span>
                                    </div>

                                    <div class="products_details_single">
                                        <span>{{__('common.Type')}}: </span>
                                        <span>{{$product->type ==1 ? __("product.Virtual"): __("product.Physical") }}</span>
                                    </div>
                                    <div class="products_details_single">
                                        <span>{{__('common.Category')}}: </span>
                                        <span>  {{$product->category->title}} </span>

                                    </div>
                                    <div class="products_details_single">
                                        <span>{{__('product.Brand')}}:</span>
                                        <span>{{@$product->brand->name}}</span>
                                    </div>

                                    <div class="products_details_single">
                                        <span>{{__('product.Unit')}}: </span>
                                        <span>{{@$product->unit->name}}</span>
                                    </div>
                                    @if(!$product->has_variant)
                                        <div class="products_details_single">
                                            <span>{{__('common.Price')}}: </span>

                                            <span>{{getPriceFormat($product->price)}}</span>
                                        </div>

                                        <div class="products_details_single">
                                            <span>{{__('product.discount')}}: </span>
                                            <span>{{ ($product->discount_type == 1) ? single_price($product->discount) : $product->discount. "%" }}</span>
                                        </div>
                                    @endif
                                    @if ($product->is_physical != 1 && $product->product_type == 1 && @$product->productSku->first()?->digital_file->file_source != null)
                                        <div class="products_details_single">
                                            <span>{{__('product.Download')}}: </span>
                                            <span> <a
                                                    href="{{ asset($product->soft_file) }}">{{ __('common.Download') }}</a>
                                        </span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @if (count($product->product_image) > 0)
                            <div class="col-12">
                                <div class="mb-35">
                                    <div class="box_header m-0">
                                        <div class="main-title d-flex mb-15">
                                            <h3 class="mb-0">{{__('product.Image')}}</h3>
                                        </div>
                                    </div>
                                    <div class="gallary_img_div">
                                        @foreach ($product->product_image as $key => $gallary_image)
                                            <div class="gallary_img">
                                                <img src="{{showImage($gallary_image->thumbnail)}}"
                                                     alt="">
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                        @if (count($product->productSku) > 0)
                            <div class="col-12 mb-40">
                                <div class="QA_section3 QA_section_heading_custom">
                                    <div class="box_header m-0">
                                        <div class="main-title d-flex mb-10">
                                            <h3 class="mb-0">{{__('product.Variants')}} <span
                                                    class="f_s_12 f_w_500 theme_text2 ">({{ count($product->productSku) }}
                                                    {{__('common.Items')}})</span></h3>
                                        </div>
                                    </div>
                                    <div class="QA_section QA_section_heading_custom check_box_table">
                                        <div class="QA_table">
                                            <table class="w-100">
                                                <thead>
                                                <tr>
                                                    <th scope="col">{{__('store.SKU')}}</th>
                                                    <th scope="col">{{__('product.price')}}</th>
                                                </tr>
                                                </thead>
                                                <tbody class="text-left">
                                                @foreach($product->productSku as $key => $sku)
                                                    <tr>
                                                        <td>{{ $sku->sku }}</td>
                                                        <td>{{ getPriceFormat($sku->price) }}</td>

                                                    </tr>
                                                @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                        <div class="col-12 mt-40 mb-20">
                            <div class="description_box">
                                <h4 class="f_s_14 f_w_500 mb_10">{{__('store.Description')}}:</h4>
                                <p class="f_w_400">
                                    {!! $product->description !!}
                                </p>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
