<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CreateShippingRequest extends FormRequest
{
    public function rules()
    {
        return [
            'method_name' => 'required|max:255|unique:shipping_methods,method_name',
            'carrier_id' => 'nullable',
            'cost_based_on' => 'required',
            'cost' => 'required',
            'shipment_time' => 'required',
            'minimum_shopping' => 'nullable',
        ];
    }

    public function authorize()
    {
        return true;
    }
}
