<?php

namespace Modules\Store\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CarrierRequest extends FormRequest
{
    public function rules()
    {
        return [
            'name' => ['required', Rule::unique('product_carriers', 'name')->where(function ($q) {
                $seller_id = getParentSellerId();
                return $q->where('id', '!=', $this->id)->where('created_by', $seller_id);
            })
            ],
            'tracking_url' => 'nullable',
        ];

    }

    public function messages()
    {
        return validationMessage($this->rules());
    }

    public function authorize()
    {
        return true;
    }
}
