<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddQtyToCartsTable extends Migration
{
    public function up()
    {
        Schema::table('carts', function (Blueprint $table) {
            if (!Schema::hasColumn('carts', 'qty')) {
                $table->integer('qty')->default(1);
            }

            if (!Schema::hasColumn('carts', 'is_store')) {
                $table->boolean('is_store')->default(0);
            }

            if (!Schema::hasColumn('carts', 'attributes_values')) {
                $table->text('attributes_values')->nullable();
            }

            if (!Schema::hasColumn('carts', 'product_sku_id')) {
                $table->integer('product_sku_id')->nullable();
            }

            if (!Schema::hasColumn('carts', 'product_sku_label')) {
                $table->string('product_sku_label')->nullable();
            }
        });
    }

    public function down()
    {
    }
}
