<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductAuthorsTable extends Migration
{
    public function up()
    {
        Schema::create('product_authors', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('publication_id')->nullable();
            $table->unsignedInteger('user_id');
            $table->longText('title')->nullable();
            $table->boolean('status')->default(1);
            $table->integer('lms_id')->default(1);
            $table->string('image')->nullable();
            $table->longText('description')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('product_authors');
    }
}
