@extends('backend.master')
@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box ">
                        <form action="{{ route('registration_bonus.setting.update') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <label class="switch_toggle" for="bonus_active">
                                                <input type="checkbox" id="bonus_active" name='bonus_status'
                                                       value="1" {{!empty($setting) && $setting->is_active == 1 ? 'checked': ''}}>
                                                <i class="slider round"></i> <span></span>
                                            </label>

                                            <span class="ms-2">{{ _trans("coupons.Active") }}</span>
                                        </div>
                                        <div class="col-lg-12 mt-2">
                                            <small
                                                class="">{{ _trans('coupons.By activating this feature, registration bonus will be awarded for new users') }}</small>
                                        </div>
                                    </div>


                                    <div class="row mt-4">
                                        <div class="col-lg-12">
                                            <label class="switch_toggle" for="instant_bonus">
                                                <input type="checkbox" id="instant_bonus" name="instant_bonus"
                                                       value="1" {{ $setting->instant_bonus == 1 ? "checked":'' }}>
                                                <i class="slider round"></i> <span></span>
                                            </label>
                                            <span class="ms-2">
                                            {{ _trans("coupons.Unlock registration bonus instantly") }}
                                            </span>
                                        </div>
                                        <div class="col-lg-12 mt-2">
                                            <small>{{ _trans('coupons.Users can use the bonus instantly after registration and can make purchases') }}</small>
                                        </div>
                                    </div>


                                    <div class="row mt-4 referral {{ $setting->instant_bonus == 1 ? "d-none":'' }}"
                                         id="referral_bonus_div">
                                        <div class="col-lg-12">
                                            <label class="switch_toggle" for="referral_bonus">
                                                <input type="checkbox" id="referral_bonus" name="referral_bonus"
                                                       value="1" {{ $setting->bonus_on_referrer == 1 ? "checked":'' }}>
                                                <i class="slider round"></i> <span></span>
                                            </label>
                                            <span class="ms-2">
                                            {{ _trans("coupons.Unlock registration bonus with referral") }}
                                            </span>
                                        </div>
                                        <div class="col-lg-12 mt-2">
                                            <small>{{ _trans('coupons.Users need to refer a specific number of users to unlock the bonus') }}</small>
                                        </div>
                                    </div>

                                    <div class="row mt-4 {{ $setting->bonus_on_referrer == 0 ? "d-none" : '' }}"
                                         id='referral_users_div'>
                                        <div class="col-lg-12">
                                            <label
                                                for="referral_users">{{ _trans("coupons.Number of referred users") }}</label>
                                            <input type="text" class="primary_input_field" name='referral_users'
                                                   id='referral_users' value='{{ $setting->referrer_users }}'>
                                        </div>
                                    </div>

                                    <div class="row mt-4 referral {{ $setting->instant_bonus == 1 ? "d-none":'' }}">
                                        <div class="col-lg-12">
                                            <label class="switch_toggle" for="referral_purchase">
                                                <input type="checkbox" id="referral_purchase" name="referral_purchase"
                                                       value="1" {{  $setting->bonus_on_purchase == 1 ? "checked":'' }}>
                                                <i class="slider round"></i> <span></span>
                                            </label>
                                            <span class="ms-2">
                                            {{ _trans("coupons.Enable referred users purchase") }}
                                            </span>
                                        </div>
                                        <div class="col-lg-12 mt-2">
                                            <small>{{ _trans('coupons.Each referred user needs to purchase a specific amount to unlock the bonus') }}</small>
                                        </div>
                                    </div>

                                    <div class="row mt-4  {{  $setting->bonus_on_purchase == 0 ? "d-none":'' }}"
                                         id='purchase_amount_div'>
                                        <div class="col-lg-12">
                                            <label
                                                for="purchase_amount"> {{ _trans("coupons.Purchase amount for unlocking bonus") }}</label>
                                            <input type="text" class="primary_input_field" name='purchase_amount'
                                                   id='purchase_amount' value='{{ $setting->referrer_amount }}'>
                                        </div>
                                    </div>


                                    <div class="row mt-4">
                                        <div class="col-lg-12">
                                            <label for="bonus_amount">{{ _trans("coupons.Bonus Amount") }}</label>
                                            <input type="text" class="primary_input_field"
                                                   value='{{ $setting->bonus_amount }}' name='bonus_amount'
                                                   id='bonus_amount'>
                                        </div>
                                    </div>

                                    <div class="row mt-4">
                                        <div class="col d-flex justify-content-center align-content-center">
                                            <button type="submit" class="primary-btn semi_large fix-gr-bg">
                                                <i class="ti-check"></i> {{ _trans('common.Save') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('scripts')
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {

                $(document).on('change', '#instant_bonus', function () {
                    if ($('#instant_bonus').is(':checked')) {
                        $(".referral").addClass('d-none');
                    } else {
                        $(".referral").removeClass("d-none");
                    }
                });

                $(document).on('change', '#referral_bonus', function () {
                    if ($('#referral_bonus').is(':checked')) {
                        $("#referral_users_div").removeClass("d-none");
                    } else {
                        $("#referral_users_div").addClass('d-none');
                    }
                });

                $(document).on('change', '#referral_purchase', function () {
                    if ($('#referral_purchase').is(':checked')) {
                        $("#purchase_amount_div").removeClass("d-none");
                    } else {
                        $("#purchase_amount_div").addClass('d-none');
                    }
                });

            });
        })(jQuery);

    </script>
@endpush
