@php use Illuminate\Support\Facades\Auth; @endphp
@extends(app('extend_view'))
@section('title')
    {{Settings('site_title') ? Settings('site_title') : 'Infix LMS'}} | @lang('chat.chat') @lang('chat.invitation')
@endsection

@section('mainContent')
    @php
        $isStudentPanel =\Illuminate\Support\Facades\Auth::user()->role_id==3
    @endphp
    @if(!$isStudentPanel)
        {{generateBreadcrumb()}}
    @endif
    <section class="main_content_iner main_content_padding" id="admin-visitor-area">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-xl-6 mt_30 mt-xl-0">
                    <div class="chat_flow_list_wrapper white-box">
                        <div class="chat_flow_list crm_full_height white_box">
                            <div class="box_header">
                                <div class="main-title">
                                    <h3 class="m-0">@lang('chat.you_requests')</h3>
                                </div>
                            </div>
                            <div class="chat_flow_list_inner">
                                <ul>
                                    @forelse($ownRequest as $myRequest)
                                        @php
                                            if (!$myRequest->requestTo){
                                                continue;
                                            }
                                        @endphp
                                        <li>
                                            <div class="single_list d-flex align-items-center">
                                                <div class="thumb">
                                                    <a href="#"><img
                                                            src="{{getProfileImage($myRequest->requestTo->image,$myRequest->requestTo->name)}}"
                                                            alt=""></a>

                                                </div>
                                                <div class="list_name">
                                                    <a target="_blank" href="{{$myRequest->requestTo->username?route('profileUniqueUrl',$myRequest->requestTo->username):''}}">
                                                        <h4>{{ $myRequest->requestTo->first_name }} <span
                                                                class="active_chat"></span></h4></a>
                                                    <p>Your request to {{ $myRequest->requestTo->first_name }} </p>
                                                </div>
                                            </div>
                                        </li>
                                    @empty
                                        <p>@lang('chat.no') @lang('chat.connection') @lang('chat.request') @lang('chat.found')</p>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 mt_30 mt-xl-0">
                    <div class="chat_flow_list_wrapper white-box">
                        <div class="chat_flow_list crm_full_height white_box">
                            <div class="box_header">
                                <div class="main-title">
                                    <h3 class="m-0">@lang('chat.people') @lang('chat.requests') @lang('chat.you') @lang('chat.to') @lang('chat.connect')</h3>
                                </div>
                            </div>
                            <div class="chat_flow_list_inner">
                                <ul>
                                    @forelse($peopleRequest as $request)
                                        @php
                                            if (!$request->requestTo){
                                                continue;
                                            }
                                        @endphp
                                        <li>
                                            <div class="single_list d-flex align-items-center">
                                                <div class="thumb">
                                                    <a href="#">
                                                        <img
                                                            src="{{getProfileImage($request->requestTo->image,$request->requestTo->name)}}"
                                                            alt=""></a>

                                                </div>
                                                <div class="list_name w-50 flex-grow-1">
                                                    <a target="_blank" href="{{$request->requestFrom->username?route('profileUniqueUrl',$request->requestFrom->username):''}}">
                                                        <h4>{{ $request->requestFrom->first_name }} <span
                                                                class="active_chat"></span></h4></a>
                                                    <p>{{ $request->requestFrom->first_name }} @lang('chat.requested') @lang('chat.to') @lang('chat.connect')</p>
                                                </div>
                                                <div class="d-flex align-items-center gap-2 flex-wrap">
                                                    <a href="{{ route('chat.invitation.action',['type' => 'accept', 'id' => $request->id]) }}"
                                                       class="single-icon primary-btn small fix-gr-bg text-white"
                                                       title="Accept">
                                                        <span class="ti-check pe-2"></span>
                                                    </a>

                                                    <a href="{{ route('chat.invitation.action',['type' => 'reject', 'id' => $request->id]) }}"
                                                       class="single-icon primary-btn small fix-gr-bg text-white"
                                                       title="Reject">
                                                        <span class="ti-close pe-2"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </li>
                                    @empty
                                        <p>@lang('chat.no') @lang('chat.connection') @lang('chat.request') @lang('chat.found')</p>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt_30">
                <div class="col-xl-6">
                    <div class="chat_flow_list_wrapper white-box">
                        <!-- chat_list  -->
                        <div class="chat_flow_list crm_full_height white_box">
                            <div class="box_header">
                                <div class="main-title">
                                    <h3 class="m-0">@lang('chat.people_connected_with_you')</h3>
                                </div>
                            </div>
                            <div class="chat_flow_list_inner">
                                <ul>
                                    @forelse($connectedPeoples as $request)
                                        <li>
                                            <div class="single_list d-flex align-items-center">
                                                <div class="thumb">
                                                    <a href="#"><img
                                                            src="{{getProfileImage($request->image,$request->name)}}"
                                                            alt=""></a>

                                                </div>
                                                <div class="list_name w-50 flex-grow-1">
                                                    <a target="_blank" href="{{$request->username?route('profileUniqueUrl',$request->username):''}}">
                                                        <h4>{{ $request->first_name }} <span
                                                                class="active_chat"></span></h4></a>
                                                    <p>{{ $request->first_name }} @lang('chat.connected_with_you')</p>
                                                </div>
                                            </div>
                                        </li>
                                    @empty
                                        <p>@lang('chat.no') @lang('chat.connection') @lang('chat.request') @lang('chat.found')</p>
                                    @endforelse
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
