@extends('appointment::layouts.master')
@php
    $table_name = 'time_slots';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-md-3">
                    <div class="white-box mb_30">
                        <div class="box_header common_table_header mb-0">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-20 mr-30 mb_xs_15px mb_sm_20px">
                                    @if (!isset($editTimeSlot))
                                        {{ __('appointment.Add New Slot') }}
                                    @else
                                        {{ __('appointment.Update Slot') }}
                                    @endif
                                </h3>
                            </div>
                        </div>

                        @if (isset($editTimeSlot))
                            @if (permissionCheck('appointment.time-slot.edit'))
                                <form action="{{ route('appointment.time-slot.update', $editTimeSlot->id) }}"
                                      method="POST" class="form-horizontal" id="timeSlot-form" name="timeSlot-form">
                                    @method('PUT')
                                    @csrf

                                    @endif
                                    @else
                                        @if (permissionCheck('appointment.time-slot.store'))
                                            <form action="{{ route('appointment.time-slot.store') }}" method="POST"
                                                  class="form-horizontal" enctype="multipart/form-data"
                                                  name="timeSlot-form">
                                                @csrf

                                                @endif
                                                @endif
                                                <div class="row">


                                                    <div class="col-xl-12 input-right-icon">
                                                        <label
                                                            class="primary_input_label mt-1">{{ __('appointment.Start Time') }}
                                                            <span
                                                                class="required_mark">*</span></label>
                                                        <div class="primary_input">
                                                            <input required
                                                                   class="primary-input primary_input_field  time form-control{{ @$errors->has('start_time') ? ' is-invalid' : '' }}"
                                                                   type="text" name="start_time"
                                                                   value="{{ isset($editTimeSlot) ? old('start_time', $editTimeSlot->start_time) : old('start_time') }}">
                                                        </div>

                                                        @if ($errors->has('start_time'))
                                                            <span class="invalid-feedback" role="alert">
                                            <strong>{{ @$errors->first('start_time') }}</strong>
                                        </span>
                                                        @endif
                                                    </div>


                                                    <div class="col-xl-12 mt-10 input-right-icon">
                                                        <label
                                                            class="primary_input_label mt-1">{{ __('appointment.End Time') }} </label>
                                                        <div class="primary_input">
                                                            <input
                                                                class="primary-input primary_input_field  time form-control{{ @$errors->has('time') ? ' is-invalid' : '' }}"
                                                                type="text" name="end_time"
                                                                value="{{ isset($editTimeSlot) ? old('end_time', $editTimeSlot->end_time) : old('end_time') }}">

                                                        </div>

                                                        @if ($errors->has('end_time'))
                                                            <span class="invalid-feedback" role="alert">
                                            <strong>{{ @$errors->first('end_time') }}</strong>
                                        </span>
                                                        @endif
                                                    </div>


                                                    @if (auth()->user()->role_id == 1)
                                                        <div class="col-xl-12 mt-10">
                                                            <div class="primary_input mb-25">
                                                                <label class="primary_input_label"
                                                                       for="user_id">{{ __('common.Instructor') }}</label>
                                                                <select class="primary_select " name="user" id="user_id"
                                                                    {{ $errors->has('user') ? 'autofocus' : '' }}>
                                                                    <option
                                                                        data-display="{{ __('appointment.Select Instructor') }} "
                                                                        value="">
                                                                        {{ __('appointment.Select Instructor') }} </option>
                                                                    @foreach ($instructors as $instructor)
                                                                        <option
                                                                            value="{{ $instructor->id }}" {{ isset($editTimeSlot) ? ($editTimeSlot->user_id == $instructor->id ? 'selected' : '') : '' }}>{{ $instructor->name }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @php
                                                        $tooltip = '';
                                                        if (permissionCheck('appointment.time-slot.store')) {
                                                            $tooltip = '';
                                                        } else {
                                                            $tooltip = trans('courses.You have no permission to add');
                                                        }
                                                    @endphp
                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center pt_20">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip"
                                                                    title="{{ @$tooltip }}" id="save_button_parent">
                                                                <i class="ti-check"></i>
                                                                @if (!isset($editTimeSlot))
                                                                    {{ __('common.Save') }}
                                                                @else
                                                                    {{ __('common.Update') }}
                                                                @endif
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-20" id="page_title">{{ __('appointment.Time Slot List') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('appointment.Start Time') }}</th>
                                            <th scope="col">{{ __('appointment.End Time') }}</th>
                                            <th scope="col">{{ __('common.Duration') }}</th>

                                            <th scope="col">{{ __('common.Instructor') }}</th>

                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($timeSlots as $key => $slot)
                                            <tr>
                                                <th class="m-2">{{ $loop->iteration }}</th>
                                                <td>{{ date('h:i A', strtotime(@$slot->start_time)) }}</td>
                                                <td>{{ date('h:i A', strtotime(@$slot->end_time)) }}</td>
                                                <td>{{ $slot->duration }}</td>
                                                <td>{{ $slot->instructor->name }}</td>


                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               @if(auth()->user()->role_id !=1)
                                                                   @if(auth()->user()->id == $slot->created_by)class="status_enable_disable"
                                                               @else
                                                                   disabled
                                                               @endif
                                                               @else
                                                                   class="status_enable_disable"
                                                               @endif
                                                               @if (@$slot->status == 1) checked @endif
                                                               value="{{ @$slot->id }}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$slot->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{ @$slot->id }}">

                                                            @if (permissionCheck('appointment.time-slot.edit'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{ route('appointment.time-slot.edit', @$slot->id) }}">{{ __('common.Edit') }}</a>
                                                            @endif
                                                            @if (permissionCheck('appointment.time-slot.destroy'))
                                                                <a onclick="confirm_modal('{{ route('appointment.time-slot.destroy', @$slot->id) }}');"
                                                                   class="dropdown-item edit_brand">{{ __('common.Delete') }}</a>
                                                            @endif

                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @include('backend.partials.delete_modal')

@endsection
@push('scripts')

    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>

@endpush
