@extends('appointment::layouts.master')
@php
    $table_name = 'booking';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@section('mainContent')
    <input type="hidden" id="row_count" value="1">
    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="white-box  ">
                        <div class="white_box_tittle list_header main-title mb-0">
                            <h3 class="mb-20" id="page_title">{{__('student.Filter Enroll History')}}</h3>

                        </div>
                        @php
                            $div = auth()->user()->role_id == 1 ? 'col-xl-3 col-md-3 col-lg-3' : 'col-xl-3 col-md-3 col-lg-3';
                            $divBtn = auth()->user()->role_id == 1 ? 'col-md-12 col-xl-12 mt-30' : 'col-md-12 col-xl-12 mt-30';
                        @endphp

                        <form method="POST" action="{{ route('appointment.booking.pending') }}">
                            @csrf
                            <div class="row">

                                <div class="{{ $div }}">

                                    <label class="primary_input_label"
                                           for="instructor">{{__('appointment.Time Slot')}}</label>
                                    <select class="primary_select" name="time_slot" id="instructor">
                                        <option data-display="{{__('common.Select')}} {{__('appointment.Time Slot')}}"
                                                value="">{{__('common.Select')}} {{__('appointment.Time Slot')}}</option>
                                        @foreach($timeSlots as $slot)
                                            <option
                                                value="{{$slot->id}}" {{isset($payload) ? ($payload['time_slot'] == $slot->id ? 'selected' : '') : ''}}>
                                                {{  date('h:i A', strtotime(@$slot->start_time))  }} -
                                                {{date('h:i A', strtotime(@$slot->end_time))  }} </option>
                                        @endforeach
                                    </select>

                                </div>
                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="startDate">{{__('common.Select')}} {{__('common.Start Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="startDate" type="text" name="start_date"
                                                               value="{{isset($payload)?!empty($payload['start_date'])?date('m/d/Y', strtotime($payload['start_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="start-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ $div }}">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="admissionDate">{{__('common.Select')}} {{__('common.End Date')}}</label>
                                        <div class="primary_datepicker_input">
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}"
                                                               class="primary_input_field primary-input date form-control"
                                                               id="admissionDate" type="text" name="end_date"
                                                               value="{{isset($payload)?!empty($payload['end_date'])?date('m/d/Y', strtotime($payload['end_date'])):'':''}}"
                                                               autocomplete="off">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="ti-calendar" id="admission-date-icon"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="{{ $div }} d-none">
                                    <label class="primary_input_label"
                                           for="status">{{__('common.Status')}}</label>
                                    <select class="primary_select" name="status">
                                        <option
                                            value="1" {{ isset($payload) ? ($payload['status'] == 1 ?'selected':'') :''}}>{{ __('appointment.Active') }}</option>
                                        <option
                                            value="0" {{ isset($payload) ? ($payload['status'] == 0 ?'selected':'') :''}}>{{ __('appointment.Pending') }}</option>
                                    </select>
                                </div>
                                @if(auth()->user()->role_id==1)
                                    <div class="{{ $div }}">

                                        <label class="primary_input_label"
                                               for="instructor">{{__('courses.Instructor')}}</label>
                                        <select class="primary_select" name="instructor" id="instructor">
                                            <option data-display="{{__('common.Select')}} {{__('courses.Instructor')}}"
                                                    value="">{{__('common.Select')}} {{__('courses.Instructor')}}</option>
                                            @foreach($instructors as $data)
                                                <option
                                                    value="{{$data->id}}" {{ isset($payload) ? ($payload['instructor'] == $data->id?'selected':'') :''}}>{{@$data->name}} </option>
                                            @endforeach
                                        </select>

                                    </div>
                                @endif
                                <div class="{{ $divBtn }}">
                                    <div class="search_course_btn text-end">
                                        <button type="submit"
                                                class="primary-btn radius_30px   fix-gr-bg">
                                            <i class="ti-search"></i>
                                            {{__('common.Filter History')}}</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0">{{ __('appointment.Pending Booking List') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('common.Student Name') }}</th>
                                            <th scope="col">{{ __('common.Date') }}</th>
                                            <th scope="col">{{ __('appointment.Start Time') }}</th>
                                            <th scope="col">{{ __('appointment.End Time') }}</th>

                                            <th scope="col">{{ __('common.Instructor') }}</th>
                                            <th scope="col">{{ __('appointment.Current Student') }}</th>

                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($booking_list as $key => $booking)
                                            <tr>
                                                <th class="m-2">{{ $loop->iteration }}</th>
                                                <td>{{ $booking->userInfo->name }}</td>
                                                <td>{{ $booking->schedule->schedule_date }}</td>
                                                <td>{{ $booking->schedule ? date('h:i A', strtotime(@$booking->schedule->slotInfo->start_time)) :'' }}</td>
                                                <td>{{ $booking->schedule ? date('h:i A', strtotime(@$booking->schedule->slotInfo->end_time)) :'' }}</td>

                                                <td>{{ $booking->schedule->userInfo->name }}</td>

                                                <td>

                                                    @if( ($booking->currentStudent) )
                                                        <p>
                                                            <a href="{{ route('appointment.booking.user',['date'=>$booking->schedule->schedule_date, 'time_slot' => $booking->schedule->slot_id,'instructor_id'=>$booking->instructor_id]) }}"
                                                               target="_blank">
                                                                <strong>({{ ($booking->currentStudent) }}
                                                                    )</strong></a>
                                                        </p>

                                                    @endif
                                                </td>
                                                <td class="nowrap">
                                                    {{ $booking->status ==1 ? __('appointment.Active') : __('appointment.Pending') }}
                                                </td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{ @$booking->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true" aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        @if($booking->status==0)
                                                            <div class="dropdown-menu dropdown-menu-right"
                                                                 aria-labelledby="dropdownMenu1{{ @$booking->id }}">
                                                                @if (permissionCheck('appointment.booking.approve'))
                                                                    @if($booking->schedule->schedule_date >= date('Y-m-d'))
                                                                        <a class="dropdown-item "
                                                                           onclick="apporve_modal('{{ route('appointment.booking.approve', @$booking->id) }}');">{{ __('common.Approve') }}</a>
                                                                    @endif
                                                                @endif
                                                                @if (permissionCheck('appointment.booking.reject'))
                                                                    <a class="dropdown-item "
                                                                       onclick="reject_modal('{{ route('appointment.booking.reject', @$booking->id) }}');"
                                                                    >{{ __('common.Reject') }}</a>
                                                                @endif
                                                            </div>
                                                        @endif
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @include('appointment::booking._approve_modal')
    @include('appointment::booking._reject_modal')
@endsection
@push('scripts')
    <script type="application/javascript">
        (function ($) {
            "use strict";

            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6, 7]);

            $('#lms_table').DataTable(dataTableOptions);
        })(jQuery);


    </script>
@endpush
