<?php

namespace Modules\Appointment\Entities;

use App\Traits\Tenantable;
use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class InstructorReview extends Model
{
    use Tenantable;

    protected $fillable = ['instructor_id',
        'user_id', 'star'];

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->withDefault();
    }

    public function instructor()
    {
        return $this->belongsTo(User::class, 'instructor_id', 'id')->where('role_id', 2)->withDefault();
    }

    public function getRecentReviewAttribute()
    {
        $diffInDays = Carbon::parse($this->created_at)->diffInDays();
        $showDiff = Carbon::parse($this->created_at)->diffForHumans();
        if ($diffInDays > 0) {
            $showDiff .= ', ' . Carbon::parse($this->created_at)->addDays($diffInDays)->diffInHours() . ' Hours';
        }
        return $showDiff;
    }
}
