<?php

use App\Models\LmsInstitute;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\Appointment\Entities\AppointmentFrontendPage;

class CreateAppointmentFrontendPagesTable extends Migration
{

    public function up()
    {
        if (!Schema::hasTable('appointment_frontend_pages')) {
            Schema::create('appointment_frontend_pages', function (Blueprint $table) {
                $table->id();
                $table->string('name')->nullable();
                $table->string('title')->nullable();
                $table->string('slug')->nullable();
                $table->tinyInteger('status')->nullable()->default(1);
                $table->integer('position')->nullable();
                $table->tinyInteger('is_default')->nullable();
                $table->tinyInteger('is_static')->nullable()->default(0);
                $table->tinyInteger('is_page_builder')->nullable()->default(1);
                $table->unsignedBigInteger('lms_id')->nullable();
                $table->longText('description')->nullable();
                $table->foreign('lms_id')->on('lms_institutes')->references('id')->cascadeOnDelete();
                $table->string('type')->nullable();
                $table->integer('created_by')->nullable()->default(1);
                $table->integer('updated_by')->nullable()->default(1);

                $table->timestamps();
            });
        }


        $institutes = LmsInstitute::get();
        $titles = [
            ['Hero Section', 'hero-section'],
            ['Teaching Category', 'teaching-category'],
            ['Feature 01', 'feature-01'],
            ['Feature 02', 'feature-02'],
            ['Feature 03', 'feature-03'],
            ['Feature 04', 'feature-04'],
            ['Feature 05', 'feature-05'],
            ['Feature 06', 'feature-06'],
            ['Feature 07', 'feature-07'],
            ['Partner', 'partner'],
            ['Instructor Breadcrumb', 'instructor-breadcrumb'],
        ];
        $becomeInstructors = [
            ['Tutor Feature', 'tutor-feature'],
            ['Tutor Sign Up', 'tutor-sign-up'],
            ['Tutor Testimonial', 'tutor-testimonial'],
            ['Tutor Connect', 'tutor-connect'],
            ['Tutor FAQ', 'tutor-faq'],
        ];
        foreach ($institutes as $institute) {
            $i = 1;
            foreach ($titles as $key => $title) {
                $page = new AppointmentFrontendPage();
                $page->title = $title[0];
                $page->name = $title[1];
                $page->slug = $title[1];
                $page->position = $key + 1;
                $page->is_default = 1;

                if ($title[1] == 'teaching-category') {
                    $page->is_page_builder = 0;
                    $page->is_static = 1;

                }
                if ($title[1] == 'partner') {
                    $page->is_page_builder = 0;
                    $page->is_static = 1;

                }

                $page->type = $title[1] == 'instructor-breadcrumb' ? 'tutor_page' : 'appointment_page';
                $page->lms_id = $institute->id;
                $page->save();
            }
            foreach ($becomeInstructors as $tutorPage) {
                $page = new AppointmentFrontendPage();
                $page->title = $tutorPage[0];
                $page->name = $tutorPage[1];
                $page->slug = $tutorPage[1];
                $page->position = $key + 1;
                $page->is_default = 1;
                $page->type = 'become_instructor_page';
                $page->lms_id = $institute->id;
                $page->save();
            }
        }
    }


    public function down()
    {
        Schema::dropIfExists('appointment_frontend_pages');
    }
}
