<?php use Illuminate\Support\Facades\Auth; ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/backend/css/student_list.css')); ?>"/>
<?php $__env->stopPush(); ?>
<?php
    $table_name='users';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">

                <div class="col-lg-12 ">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table ">
                            <div class="white-box">
                                <form action="<?php echo e(isset($user)?route('student.update'):route('student.store')); ?>"
                                      method="POST"
                                      enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="id" value="<?php echo e(isset($user)?$user->id:''); ?>">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for=""><?php echo e(__('common.Name')); ?>

                                                    <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="name" placeholder="-"
                                                       type="text" id="addName"
                                                       value="<?php echo e(old('name',isset($user)?$user->name:'')); ?>" <?php echo e($errors->first('name') ? 'autofocus' : ''); ?>>
                                            </div>
                                        </div>


                                    </div>
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-35">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.About')); ?></label>
                                                <textarea class="lms_summernote" name="about" id="addAbout"
                                                          cols="30"
                                                          rows="10"><?php echo e(old('about',isset($user)?$user->about:'')); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-15">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Date of Birth')); ?>

                                                </label>
                                                <div class="primary_datepicker_input">
                                                    <div class="g-0  input-right-icon">
                                                        <div class="col">
                                                            <div class="">
                                                                <input placeholder="<?php echo e(__('common.Date')); ?>"
                                                                       class="primary_input_field primary-input date form-control"
                                                                       id="startDate" type="text" name="dob"
                                                                       value="<?php echo e(old('dob',isset($user)?$user->dob:'')); ?>"
                                                                       autocomplete="off" <?php echo e($errors->first('dob') ? 'autofocus' : ''); ?>>
                                                            </div>
                                                        </div>
                                                        <button class="" type="button">
                                                            <i class="ti-calendar" id="start-date-icon"></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Phone')); ?> </label>
                                                <input class="primary_input_field phoneNumberInput"
                                                       value="<?php echo e(old('phone',isset($user)?$user->phone:'')); ?>"
                                                       name="phone" id="addPhone"
                                                       placeholder="-"
                                                       type="number" <?php echo e($errors->first('phone') ? 'autofocus' : ''); ?>>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for=""><?php echo e(__('common.Email')); ?>

                                                    <strong
                                                        class="text-danger">*</strong></label>
                                                <input class="primary_input_field" name="email" placeholder="-"
                                                       value="<?php echo e(old('email',isset($user)?$user->email:'')); ?>"
                                                       id="addEmail"
                                                       <?php echo e($errors->first('email') ? 'autofocus' : ''); ?>

                                                       type="email">
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-35">
                                                <label class="primary_input_label" for=""><?php echo e(__('common.gender')); ?>

                                                </label>

                                                <select class="primary_select"
                                                        data-course_id="<?php echo e(@$course->id); ?>" name="gender">
                                                    <option
                                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('common.gender')); ?>"
                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('common.gender')); ?> </option>

                                                    <option
                                                        value="male" <?php echo e((old('gender',isset($user)?$user->gender:'')=='male')?'checked':''); ?>><?php echo e(__('common.Male')); ?></option>
                                                    <option
                                                        value="female" <?php echo e((old('gender',isset($user)?$user->gender:'')=='female')?'checked':''); ?>><?php echo e(__('common.Female')); ?></option>
                                                    <option
                                                        value="other" <?php echo e((old('gender',isset($user)?$user->gender:'')=='other')?'checked':''); ?>><?php echo e(__('common.Other')); ?></option>


                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.company')); ?> <?php echo e(__('common.Name')); ?> </label>
                                                <input class="primary_input_field"
                                                       value="<?php echo e(old('company',isset($user)?$user->company:'')); ?>"
                                                       name="company" id="addCompany"
                                                       placeholder="-"
                                                       type="text" <?php echo e($errors->first('company') ? 'autofocus' : ''); ?>>
                                            </div>
                                        </div>
                                        <?php
                                            $selectedInstitute =isset($user)?$user->institute_id:'';
                                        ?>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Institute Name')); ?> </label>
                                                <select class="primary_select"
                                                        name="institute_id">
                                                    <option
                                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('student.Institute')); ?>"
                                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('student.Institute')); ?> </option>

                                                    <?php $__currentLoopData = $institutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $institute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                            value="<?php echo e($institute->id); ?>" <?php echo e(($selectedInstitute==$institute->id)?'selected':''); ?>><?php echo e($institute->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-xl-6">
                                            <div class=" mb-35">
                                                <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'image','type' => 'image','mediaId' => ''.e(isset($user)?$user->image_media?->media_id:'').'','label' => ''.e(__('common.Image')).'','note' => '']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'image','type' => 'image','media_id' => ''.e(isset($user)?$user->image_media?->media_id:'').'','label' => ''.e(__('common.Image')).'','note' => '']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label" for=""><?php echo e(__('common.Password')); ?>

                                                    <strong
                                                        class="text-danger">*</strong></label>
                                                <div class="input-group mb-2 mr-sm-2">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text"><i style="cursor:pointer;"
                                                                                         class="fas fa-eye-slash eye toggle-password"></i>
                                                        </div>
                                                    </div>
                                                    <input type="password" class="form-control primary_input_field"
                                                           id="addPassword" name="password"
                                                           autocomplete="new-password"
                                                           placeholder="<?php echo e(__('common.Minimum 8 characters')); ?>" <?php echo e($errors->first('password') ? 'autofocus' : ''); ?>>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Confirm Password')); ?> <strong
                                                        class="text-danger">*</strong></label>
                                                <div class="input-group mb-2 mr-sm-2">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text"><i style="cursor:pointer;"
                                                                                         class="fas fa-eye-slash eye toggle-password"></i>
                                                        </div>
                                                    </div>
                                                    <input type="password" class="form-control primary_input_field"
                                                           <?php echo e($errors->first('password_confirmation') ? 'autofocus' : ''); ?>

                                                           id="addCpassword" name="password_confirmation"
                                                           placeholder="<?php echo e(__('common.Minimum 8 characters')); ?>">
                                                </div>
                                                
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Facebook URL')); ?></label>
                                                <input class="primary_input_field" name="facebook" placeholder="-"
                                                       id="addFacebook"
                                                       type="text"
                                                       value="<?php echo e(old('facebook',isset($user)?$user->facebook:'')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Twitter URL')); ?></label>
                                                <input class="primary_input_field" name="twitter" placeholder="-"
                                                       id="addTwitter"
                                                       type="text"
                                                       value="<?php echo e(old('twitter',isset($user)?$user->twitter:'')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">

                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.LinkedIn URL')); ?></label>
                                                <input class="primary_input_field" name="linkedin" placeholder="-"
                                                       id="addLinked"
                                                       type="text"
                                                       value="<?php echo e(old('linkedin',isset($user)?$user->linkedin:'')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Youtube URL')); ?></label>
                                                <input class="primary_input_field" name="youtube" placeholder="-"
                                                       id="addYoutube"
                                                       type="text"
                                                       value="<?php echo e(old('youtube',isset($user)?$user->youtube:'')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-xl-6">
                                            <div class="primary_input mb-25">
                                                <label class="primary_input_label"
                                                       for=""><?php echo e(__('common.Instagram URL')); ?></label>
                                                <input class="primary_input_field" name="instagram" placeholder="-"
                                                       id="addInstagram"
                                                       type="text"
                                                       value="<?php echo e(old('instagram',isset($user)?$user->instagram:'')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-12 text-center pt_15">
                                        <div class="d-flex justify-content-center">
                                            <button class="primary-btn semi_large2  fix-gr-bg"
                                                    id="save_button_parent"
                                                    type="submit"><i
                                                    class="ti-check"></i> <?php echo e(isset($user)?__('common.Update'):__('common.Save')); ?> <?php echo e(__('student.Student')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

    <script src="<?php echo e(asset('public/backend/js/student_list.js')); ?>"></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/minialms/app.minialms.com/Modules/StudentSetting/Providers/../Resources/views/student_create.blade.php ENDPATH**/ ?>