<?php

namespace Modules\WhatsappSupport\Traits;

use Intervention\Image\Drivers\Gd\Driver;
use Intervention\Image\ImageManager;
use Carbon\Carbon;
trait ImageStore
{

    public static function saveAvatarImage($image, $height = null ,$lenght = null)
    {
        $manager = new ImageManager(new Driver());

        if(isset($image)){
            $current_date  = Carbon::now()->format('d-m-Y');
            $image_extention = str_replace('image/','',$manager->create($image)->mime());

            if($height != null && $lenght != null ){
                $img = $manager->create($image)->resize($height, $lenght);
            }else{
                $img = $manager->create($image);
            }

            $img_name = 'public/whatsapp-support/avatar'.'/'.uniqid().'.'.$image_extention;
            $img->save($img_name);
            return $img_name;
        }else{
            return null ;
        }
    }
}
