<?php

namespace Modules\WhatsappSupport\Entities;

use App\Traits\Tenantable;
use Illuminate\Database\Eloquent\Model;
use Modules\Setting\Entities\UsedMedia;

class Settings extends Model
{
    use Tenantable;

    protected $guarded = [];

    protected $table = 'whatsapp_support_settings';

    protected static function newFactory()
    {
        return \Modules\WhatsappSupport\Database\factories\SettingsFactory::new();
    }

    public function isMulti()
    {
        return $this->agent_type == 'multi';
    }

    public function isNotDisableForAdmin()
    {
        if (!$this->disable_for_admin_panel) {
            return true;
        } elseif ($this->disable_for_admin_panel && \Request::is('admin/*')) {
            return false;
        } else {
            return true;
        }
    }

    public function isSingle()
    {
        return $this->agent_type == 'single';
    }

    public function forDesktop()
    {
        return $this->availability == 'desktop';
    }

    public function forMobile()
    {
        return $this->availability == 'mobile';
    }

    public function forBoth()
    {
        return $this->availability == 'both';
    }

    public function bubble_logo_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'bubble_logo');
    }
    public function whatsapp_logo_media()
    {
        return $this->morphOne(UsedMedia::class, 'usable')->where('used_for', 'whatsapp_logo');
    }

}
