@extends('backend.master')
@push('styles')
    <style>
        .subject_link {
            color: #7C32FF !important;
            font-weight: 300 !important;
        }

        .limit_text {
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;

        }

        .no_reply_ticket {
            font-weight: 600 !important;
        }

        .color_inherit {
            color: #828bb2 !important;
        }


    </style>

@endpush
@section('mainContent')
    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <form action="{{ route('ticket.my_ticket') }}" method="get">
                        <div class="row white-box">
                            <div class="col-lg-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{ __('common.Category') }}</label>
                                    <select name="category_id" id="category_id" class="primary_select mb-15">
                                        <option value="" selected>{{__('common.Select')}}</option>
                                        @foreach ($CategoryList as $key => $item)
                                            <option
                                                {{isset($category_id)?$category_id == $item->id?'selected':'':''}} value="{{ $item->id }}">{{ $item->name }} </option>
                                        @endforeach

                                    </select>
                                    @if ($errors->has('category_id'))
                                        <span class="text-danger"
                                              id="error_category_id">{{ $errors->first('category_id') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{ __('ticket.priority') }}</label>
                                    <select name="priority_id" id="priority_id" class="primary_select mb-15">
                                        <option value="" selected>{{__('common.Select')}}</option>
                                        @foreach ($PriorityList as $key => $item)
                                            <option
                                                {{isset($priority_id)?$priority_id == $item->id?'selected':'':''}} value="{{ $item->id }}">{{ $item->name }} </option>
                                        @endforeach

                                    </select>
                                    @if ($errors->has('priority_id'))
                                        <span class="text-danger"
                                              id="error_priority_id">{{ $errors->first('priority_id') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label" for="">{{ __('common.Status') }}</label>
                                    <select name="status_id" id="status_id" class="primary_select mb-15">
                                        <option value="" selected>{{__('common.Select')}}</option>
                                        @foreach ($StatusList as $key => $status)
                                            <option
                                                {{isset($status_id)?$status_id == $status->id?'selected':'':''}} value="{{ $status->id }}">{{ $status->name }} </option>
                                        @endforeach

                                    </select>
                                    @if ($errors->has('status_id'))
                                        <span class="text-danger"
                                              id="error_status_id">{{ $errors->first('status_id') }}</span>
                                    @endif
                                </div>
                            </div>

                            <div class="col-lg-12  small text-end">
                                <button type="submit" id="search_btn" class="primary-btn   fix-gr-bg">
                                    <span class="ti-search pe-2"></span>
                                    {{__('common.Search')}}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="white-box mt-4">
                    <div class="col-lg-12 mt-20 g-0">
                        <div class="main-title">
                            <h3 class="mb-20" id="page_title">{{__('ticket.ticket_list')}}</h3>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="row  mt-40">
                            <div class="col-lg-12">
                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <div class="">
                                            <div id="">
                                                <table id="lms_table" class="table">
                                                    <thead>
                                                    <tr>
                                                        <th scope="col">{{__('common.SL')}}</th>
                                                        <th scope="col">{{__('common.User')}}</th>
                                                        <th scope="col">{{__('ticket.ticket')}}</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="url" id="url2"
                       value="{{ request()->getQueryString() ? request()->getQueryString() : '' }}">

            </div>
        </div>
    </section>
@endsection

@push('scripts')

    <script type="text/javascript">
        (function ($) {
            "use strict";
            let url = $('#url2').val();
            let new_url = "{{ route('ticket.my_ticket_get_data') }}?" + url;

            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = new_url;
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id'},
                {data: 'username', name: 'user.email'},
                {data: 'ticket', name: 'support_tickets.subject'},
            ]
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);

            $('#lms_table').DataTable(dataTableOptions);


            $(document).on('click', '.delete_ticket', function (event) {
                event.preventDefault();
                let id = $(this).data('id');
                $('#deleteItem').modal('show');
                $('#dataId').val(id);
            });

        })(jQuery);

    </script>

@endpush
