<?php

namespace Modules\SupportTicket\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\SupportTicket\Services\SupportTicketCategoryService;

class SupportTicketCategoryController extends Controller
{
    protected $supportTicketCategoryService;

    public function __construct(SupportTicketCategoryService $supportTicketCategoryService)
    {

        $this->supportTicketCategoryService = $supportTicketCategoryService;
    }

    public function index()
    {
        try {
            $data['categories'] = $this->supportTicketCategoryService->getAll();
            return view('supportticket::category.index', $data);
        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function store(Request $request)
    {
        $validate_rules = [
            'name' => 'required|string|unique:support_ticket_category,name'

        ];


        $request->validate($validate_rules, validationMessage($validate_rules));
        $this->supportTicketCategoryService->create($request->except('_token'));

        Toastr::success(trans('common.Operation successful'), trans('common.Success'));

        return redirect()->route('ticket.category.index');

    }

    public function edit(Request $request)
    {
        $data['edit'] = $this->supportTicketCategoryService->find($request->id);
        $data['categories'] = $this->supportTicketCategoryService->getAll();

        return view('supportticket::category.index', $data);
    }

    public function update(Request $request)
    {

        $validate_rules =[
            'name' => 'required|string|unique:support_ticket_category,name,' . $request->id
        ];
        $request->validate($validate_rules, validationMessage($validate_rules));

        $this->supportTicketCategoryService->update($request->except('_token'));
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));

        return redirect()->route('ticket.category.index');
    }



    public function status(Request $request)
    {
        try {
            $this->supportTicketCategoryService->statusChange($request->except('_token'));
            return true;
        } catch (Exception $e) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));

            return response()->json([
                'error' => $e->getMessage()
            ], 503);
        }
    }

    public function destroy(Request $request)
    {
        $this->supportTicketCategoryService->delete($request->id);
        Toastr::success(trans('common.Operation successful'), trans('common.Success'));

        return redirect()->route('ticket.category.index');
    }
}
