@extends('backend.master')
@section('styles')
    <style>
        .anchore_color {
            color: #415094;
        }
    </style>
@endsection
@section('mainContent')
    {{ generateBreadcrumb() }}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-lg-4">
                    <div class="create_div">

                        <form
                            action="{{ isset($edit) ? route('store.reason.update', $edit->id) : route('store.reason.store') }}"
                            method="POST">
                            @csrf
                            <div class=" white-box box_shadow_white mb-20">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">
                                            @if (isset($edit))
                                                {{ __('product.edit_reason') }}
                                            @else
                                                {{ __('product.add_new_reason') }}
                                            @endif
                                        </h3>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="col-lg-12">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label" for=""> {{ __('product.reason') }}
                                                <span class="text-danger">*</span></label>
                                            <input class="primary_input_field" name="reason" id="reason"
                                                   placeholder="{{ __('product.reason') }}" type="text"
                                                   value="{{ old('reason', isset($edit) ? $edit->reason : '') }}">
                                            <span class="text-danger" id=""></span>
                                        </div>
                                    </div>

                                    <div class="col-lg-12 text-center">
                                        @if (isset($edit))
                                            <div class="d-flex justify-content-center pt_20">
                                                <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                        id="save_button_parent">
                                                    <i class=" fa fa-check "></i>

                                                    {{ __('common.Update') }}

                                                </button>
                                            </div>
                                        @else
                                            <div class="d-flex justify-content-center pt_20">
                                                <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                        id="save_button_parent">
                                                    <i class=" fa fa-check "></i>

                                                    {{ __('common.save') }}

                                                </button>
                                            </div>
                                        @endif
                                    </div>

                                </div>
                            </div>
                        </form>

                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="white-box">

                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title">{{ __('product.reason_list') }}</h3>
                            </div>
                        </div>
                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table">
                                <div class="">
                                    <div id="refund_list">
                                        <table class="table Crm_table_active3">
                                            <thead>
                                            <tr>
                                                <th scope="col">{{ __('common.SL') }}</th>
                                                <th scope="col">{{ __('common.Name') }}</th>
                                                <th scope="col">{{ __('common.Action') }}</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            @foreach ($items as $key => $item)
                                                <tr>
                                                    <th>{{ translatedNumber($key + 1 )}}</th>
                                                    <td>{{ $item->reason }}</td>
                                                    <td>
                                                        <div class="dropdown CRM_dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle"
                                                                    type="button" id="dropdownMenu2"
                                                                    data-bs-toggle="dropdown"
                                                                    aria-haspopup="true" aria-expanded="false">
                                                                {{ __('common.select') }}
                                                            </button>
                                                            <div class="dropdown-menu dropdown-menu-right"
                                                                 aria-labelledby="dropdownMenu2">

                                                                <a class="dropdown-item edit_reason"
                                                                   href="{{ route('store.reason.edit', $item->id) }}"
                                                                   type="button">{{ __('common.edit') }}</a>

                                                                <a class="dropdown-item delete-item"
                                                                   data-value="{{ route('store.reason.destroy', $item->id) }}">{{ __('common.delete') }}</a>

                                                            </div>
                                                        </div>

                                                    </td>
                                                </tr>
                                            @endforeach
                                            </tbody>
                                        </table>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <input type="hidden" name="app_base_url" id="app_base_url" value="{{ URL::to('/') }}">

    @include('backend.partials.delete_modal')
@endsection
@include('store::refund.refund_reasons.scripts')
