@extends('backend.master')
@section('mainContent')
    {{ generateBreadcrumb() }}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-md-flex">
                                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ __('product.configuration') }}</h3>
                            </div>
                        </div>
                        <form action="{{ route('store.refundsetting.update') }}" method="POST"
                              enctype="multipart/form-data">
                            @csrf

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label"
                                               for="">{{ __('product.Refund Status') }}</label>
                                        <label class="switch_toggle" for="checkbox">
                                            <input type="checkbox" id="checkbox" name="refund_status"
                                                   {{ Settings('refund_status') == 1 ? 'checked' : '' }} class="refund_status">
                                            <div class="slider round"></div>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="primary_input mb-15">
                                        <label class="primary_input_label" for="">
                                            {{ __('product.Refund Times') }} {{ __('product.in_days') }}</label>
                                        <input class="primary_input_field" name="refund_times" id="refund_times"
                                               placeholder="" type="text" value="{{ Settings('refund_times') }}">
                                        <span class="text-danger"></span>
                                    </div>
                                </div>
                                <div class="col-lg-12 d-flex align-items-center justify-content-center">
                                    <button type="submit" class="primary-btn   fix-gr-bg"
                                            id="save_button_parent"><i class="ti-check"></i>{{ __('common.Save') }}
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
