<?php

namespace Modules\Store\Http\Controllers;

use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Modules\Store\Http\Requests\UnitRequest;
use Modules\Store\Repositories\ProductUnitRepository;
use Illuminate\Foundation\Validation\ValidatesRequests;

class UnitController extends Controller
{
    use ValidatesRequests;

    protected $productUnitRepository;

    public function __construct(ProductUnitRepository $productUnitRepository)
    {
        $this->productUnitRepository = $productUnitRepository;
    }

    public function index()
    {
        try {

            $data['units'] = $this->productUnitRepository->getAll();
            return view('store::unit.index', compact('data'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }


    public function create()
    {
        return view('store::create');
    }


    public function store(UnitRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }

        $unit = $this->productUnitRepository->store($request);
        if ($unit) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function show($id)
    {
        return view('store::show');
    }


    public function edit($id)
    {
        try {

            $data['units'] = $this->productUnitRepository->getAll();
            $data['edit'] = $this->productUnitRepository->getById($id);
            return view('store::unit.index', compact('data'));
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }


    public function update(UnitRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }

        $unit = $this->productUnitRepository->update($request);
        if ($unit) {
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('store.unit.index');
        } else {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function destroy($id)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        try {

            $unit_delete = $this->productUnitRepository->destroy($id);
            if ($unit_delete) {
                Toastr::success(trans('common.Operation successful'), trans('common.Success'));
                return redirect()->back();
            } else {
                Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
                return redirect()->back();
            }
        } catch (\Exception $e) {
            GettingError($e->getMessage(), url()->current(), request()->ip(), request()->userAgent());
        }
    }
}
