<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddProductTypeToCoursesTable extends Migration
{
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            if (!Schema::hasColumn("courses", 'product_type')) {
                $table->unsignedBigInteger('product_type')->nullable()->comment('1 => virtual product 2 => physical product');
            }
            if (!Schema::hasColumn("courses", 'stock_manage')) {
                $table->unsignedBigInteger('stock_manage')->nullable();
            }
            if (!Schema::hasColumn("courses", 'stock_quantity')) {
                $table->unsignedBigInteger('stock_quantity')->nullable();
            }
        });
    }

    public function down()
    {
    }
}
